/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.Scale;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.DateNavigatorInfo;
import io.intino.alexandria.schemas.DateNavigatorSetup;
import io.intino.alexandria.ui.displays.components.AbstractDateNavigator;
import io.intino.alexandria.ui.displays.components.Eventline;
import io.intino.alexandria.ui.displays.components.Reel;
import io.intino.alexandria.ui.displays.components.Timeline;
import io.intino.alexandria.ui.displays.events.SelectEvent;
import io.intino.alexandria.ui.displays.events.SelectListener;
import io.intino.alexandria.ui.displays.notifiers.DateNavigatorNotifier;
import io.intino.alexandria.ui.model.ScaleFormatter;
import io.intino.alexandria.ui.model.datenavigator.DateNavigatorDatasource;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DateNavigator<DN extends DateNavigatorNotifier, B extends Box>
extends AbstractDateNavigator<B> {
    private List<Scale> scales = new ArrayList<Scale>();
    private Instant from;
    private Instant to;
    private Scale selectedScale = null;
    private Instant selectedInstant;
    private SelectListener selectListener;
    private SelectListener selectScaleListener;
    private DateNavigatorDatasource source = null;
    private List<Timeline<?, ?>> timelineBindings = new ArrayList();
    private List<Reel<?, ?>> reelBindings = new ArrayList();
    private List<Eventline<?, ?>> eventlineBindings = new ArrayList();

    public DateNavigator(B box) {
        super(box);
    }

    public DateNavigator<DN, B> source(DateNavigatorDatasource source) {
        this.source = source;
        return this;
    }

    public DateNavigator<DN, B> onSelect(SelectListener listener) {
        this.selectListener = listener;
        return this;
    }

    public DateNavigator<DN, B> onSelectScale(SelectListener listener) {
        this.selectScaleListener = listener;
        return this;
    }

    public DateNavigator<DN, B> select(Instant instant) {
        if (this.selectedInstant(this.selectedScale()) != null && this.selectedInstant(this.selectedScale()).equals(instant)) {
            return this;
        }
        if (instant.isBefore(this.source.from(this.selectedScale()))) {
            instant = this.source.from(this.selectedScale());
        }
        if (instant.isAfter(this.source.to(this.selectedScale()))) {
            instant = this.source.to(this.selectedScale());
        }
        this.selectInstant(this.selectedScale(), instant);
        return this;
    }

    public DateNavigator<DN, B> bindTo(Timeline<?, ?> ... timelines) {
        this.timelineBindings.addAll(List.of(timelines));
        return this;
    }

    public DateNavigator<DN, B> bindTo(Reel<?, ?> ... reels) {
        this.reelBindings.addAll(List.of(reels));
        return this;
    }

    public DateNavigator<DN, B> bindTo(Eventline<?, ?> ... eventlines) {
        this.eventlineBindings.addAll(List.of(eventlines));
        return this;
    }

    public void first() {
        Scale scale = this.selectedScale();
        this.selectInstant(scale, this.source.from(scale));
    }

    public void previous() {
        Scale scale = this.selectedScale();
        Instant current = this.selectedInstant(scale);
        Instant from = this.source.from(scale);
        current = this.source.previous(this.selectedScale(), current);
        if (current.isBefore(from)) {
            current = from;
        }
        this.selectInstant(scale, current);
    }

    public void next() {
        Scale scale = this.selectedScale();
        Instant current = this.selectedInstant(scale);
        Instant to = this.source.to(scale);
        current = this.source.next(this.selectedScale(), current);
        if (current.isAfter(to)) {
            current = to;
        }
        this.selectInstant(scale, current);
    }

    public void last() {
        Scale scale = this.selectedScale();
        this.selectInstant(scale, this.source.to(scale));
    }

    public void select(Scale scale) {
        this.changeScale(scale);
    }

    public void changeScale(String scale) {
        this.changeScale(Scale.valueOf((String)scale));
    }

    public void changeScale(Scale scale) {
        if (this.selectedScale == scale) {
            return;
        }
        this.selectedScale = scale;
        this.refreshInfo();
        this.notifyScaleSelected(this.selectedScale);
    }

    @Override
    public void init() {
        super.init();
        this.source = this.defaultDatasource();
        this.refresh();
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.source == null) {
            throw new RuntimeException("Timeline source not defined");
        }
        ((DateNavigatorNotifier)this.notifier).setup(new DateNavigatorSetup().scales(this.source.scales().stream().map(Enum::name).collect(Collectors.toList())).info(this.info()));
    }

    protected void _scales(Scale ... scales) {
        this.scales = List.of(scales);
    }

    protected void _range(Instant from, Instant to) {
        this.from = from;
        this.to = to;
    }

    private Instant selectedInstant(Scale scale) {
        return this.selectedInstant != null ? this.selectedInstant : this.source.to(this.selectedScale());
    }

    private void selectInstant(Scale scale, Instant value) {
        this.selectedInstant = value;
        this.refresh();
        this.notifySelected(value);
    }

    private Scale selectedScale() {
        return this.selectedScale != null ? this.selectedScale : this.source.scales().get(0);
    }

    private void refreshInfo() {
        ((DateNavigatorNotifier)this.notifier).refresh(this.info());
    }

    private DateNavigatorInfo info() {
        Scale scale = this.selectedScale();
        Instant date = this.selectedInstant(scale);
        DateNavigatorInfo result = new DateNavigatorInfo();
        result.selected(date);
        result.selectedLabel(ScaleFormatter.label(date, this.timezoneOffset(), scale, this.language()));
        result.scale(this.selectedScale().name());
        result.canPrevious(!ScaleFormatter.label(date, this.timezoneOffset(), scale, this.language()).equals(ScaleFormatter.label(this.source.from(scale), this.timezoneOffset(), scale, this.language())));
        result.canNext(!ScaleFormatter.label(date, this.timezoneOffset(), scale, this.language()).equals(ScaleFormatter.label(this.source.to(scale), this.timezoneOffset(), scale, this.language())));
        return result;
    }

    private DateNavigatorDatasource defaultDatasource() {
        return new DateNavigatorDatasource(){

            @Override
            public List<Scale> scales() {
                return DateNavigator.this.scales;
            }

            @Override
            public Instant from(Scale scale) {
                return DateNavigator.this.from != null ? DateNavigator.this.from : Instant.now();
            }

            @Override
            public Instant previous(Scale scale, Instant date) {
                return LocalDateTime.ofInstant(date, ZoneOffset.UTC).minus(1L, scale.temporalUnit()).toInstant(ZoneOffset.UTC);
            }

            @Override
            public Instant next(Scale scale, Instant date) {
                return LocalDateTime.ofInstant(date, ZoneOffset.UTC).plus(1L, scale.temporalUnit()).toInstant(ZoneOffset.UTC);
            }

            @Override
            public Instant to(Scale scale) {
                return DateNavigator.this.to != null ? DateNavigator.this.to : Instant.now();
            }
        };
    }

    private void notifySelected(Instant value) {
        if (this.selectListener != null) {
            this.selectListener.accept(new SelectEvent(this, value));
        }
        this.timelineBindings.forEach(t -> t.select(value));
        this.reelBindings.forEach(r -> r.select(value));
        this.eventlineBindings.forEach(r -> r.select(value));
    }

    private void notifyScaleSelected(Scale value) {
        if (this.selectScaleListener != null) {
            this.selectScaleListener.accept(new SelectEvent(this, value));
        }
        this.timelineBindings.forEach(t -> t.changeScale(value));
        this.reelBindings.forEach(r -> r.changeScale(value));
    }
}

