package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.Grid;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UIMessage;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class GridPushRequester extends io.intino.alexandria.ui.displays.requesters.ComponentPushRequester {

	public void execute(UIClient client, UIMessage message) {
		Grid display = display(client, message);
		if (display == null) return;
		String operation = operation(message);
		String data = data(message);

		if (operation.equals("sort")) {
			display.sort(io.intino.alexandria.Json.fromString(data, io.intino.alexandria.schemas.GridSortInfo.class));
			return;
		}
		else if (operation.equals("updateGroupByOptions")) {
			display.updateGroupByOptions(io.intino.alexandria.Json.fromString(data, io.intino.alexandria.schemas.GridGroupByOptionsInfo.class));
			return;
		}
		else if (operation.equals("groupBy")) {
			display.groupBy(io.intino.alexandria.Json.fromString(data, io.intino.alexandria.schemas.GridGroupByInfo.class));
			return;
		}
		else if (operation.equals("cellClick")) {
			display.cellClick(io.intino.alexandria.Json.fromString(data, io.intino.alexandria.schemas.GridCellInfo.class));
			return;
		}
		else if (operation.equals("updateVisibleColumns")) {
			display.updateVisibleColumns(java.util.List.of(io.intino.alexandria.Json.fromString(data, io.intino.alexandria.schemas.GridColumn[].class)));
			return;
		}
		else if (operation.equals("updateState")) {
			display.updateState(io.intino.alexandria.Json.fromString(data, io.intino.alexandria.schemas.GridState.class));
			return;
		}

		super.execute(client, message);
	}

}