/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.services.libraries;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.AlexandriaUiBox;
import io.intino.alexandria.ui.AlexandriaUiServer;
import io.intino.alexandria.ui.services.libraries.AlexandriaLibraryLoader;
import io.intino.alexandria.ui.services.push.PushService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AlexandriaLibraryUiInitializer {
    private final AlexandriaLibraryLoader libraryLoader;
    private final Box box;

    public AlexandriaLibraryUiInitializer(Box box, AlexandriaLibraryLoader libraryLoader) {
        this.box = box;
        this.libraryLoader = libraryLoader;
    }

    public void initialize(AlexandriaUiServer server, PushService pushService) {
        this.initDisplays(server, pushService);
        this.initProxyDisplays(server, pushService);
        this.initExposedDisplays(server, pushService);
    }

    private void initDisplays(AlexandriaUiServer server, PushService pushService) {
        try {
            Class<?> serviceClass = this.libraryLoader.serviceClass();
            if (serviceClass == null) {
                return;
            }
            Method method = serviceClass.getMethod("initDisplays", AlexandriaUiServer.class, PushService.class);
            method.invoke((Object)"initDisplays", new Object[]{server, pushService});
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Logger.error((Throwable)e);
        }
    }

    private void initProxyDisplays(AlexandriaUiServer server, PushService pushService) {
        try {
            Class<?> serviceClass = this.libraryLoader.serviceClass();
            if (serviceClass == null) {
                return;
            }
            Method method = serviceClass.getMethod("initProxyDisplays", AlexandriaUiBox.class, AlexandriaUiServer.class, PushService.class);
            method.invoke((Object)"initProxyDisplays", new Object[]{this.box, server, pushService});
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Logger.error((Throwable)e);
        }
    }

    private void initExposedDisplays(AlexandriaUiServer server, PushService pushService) {
        try {
            Class<?> serviceClass = this.libraryLoader.serviceClass();
            if (serviceClass == null) {
                return;
            }
            Method method = serviceClass.getMethod("initExposedDisplays", AlexandriaUiBox.class, AlexandriaUiServer.class, PushService.class);
            method.invoke((Object)"initExposedDisplays", new Object[]{this.box, server, pushService});
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Logger.error((Throwable)e);
        }
    }
}

