/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.documentation.model.other;

import io.intino.alexandria.schemas.Property;
import io.intino.alexandria.ui.documentation.Model;
import io.intino.alexandria.ui.documentation.model.BaseWidget;
import java.util.Arrays;
import java.util.Collections;

public class BlockWidget
extends BaseWidget {
    public BlockWidget() {
        super("With this widget you can organize your page in order to define the page layout.");
        this.facets(Arrays.asList("Paper", "Badge", "Conditional", "Absolute", "Relative", "Parallax", "Stamp", "Animated", "Drawer"));
    }

    @Override
    protected void addProperties() {
        super.addProperties();
        this.add(Model.property("label", Property.Type.ReferenceArray, "Block title if any", this.layoutOptions()));
        this.add(Model.property("layout", Property.Type.ReferenceArray, "Layout used to define children location", this.layoutOptions()));
        this.add(Model.property("spacing", Property.Type.Reference, "Spacing used between children", this.spacingOptions()));
        this.add(Model.property("value", Property.Type.Integer, "Value for badge if block has Badge facet", new String[0]).facets(Arrays.asList("badge")));
        this.add(Model.property("max", Property.Type.Integer, "Max value for badge. If value exceeds then value is collapsed", new String[0]).facets(Arrays.asList("badge")));
        this.add(Model.property("showZero", Property.Type.Bool, "By default, badge is hidden if value is 0. This behavior is managed by this property", new String[0]).facets(Arrays.asList("badge")));
        this.add(Model.property("mode", Property.Type.Word, "View used to render badge", "Normal", "Dot").facets(Arrays.asList("badge")));
        this.add(Model.property("selected", Property.Type.Reference, "Block is visible only if Option is selected", new String[0]).facets(Arrays.asList("Conditional")));
        this.add(Model.property("width", Property.Type.Integer, "Width of image in pixels with Absolute facet or percentage with Relative facet", new String[0]).facets(Arrays.asList("Absolute", "Relative")));
        this.add(Model.property("height", Property.Type.Integer, "Height of image in pixels with Absolute facet or percentage with Relative facet", new String[0]).facets(Arrays.asList("Absolute", "Relative")));
        this.add(Model.property("background", Property.Type.Text, "If parallax facet is enabled, this property defines the background to use for this effect. It must be a resource directory relative path.", new String[0]).facets(Arrays.asList("Parallax")));
        this.add(Model.property("transition", Property.Type.Word, "This property defines the transition mode to apply for animation", "Slide", "Fade", "Grow", "Zoom").facets(Arrays.asList("Animated")));
        this.add(Model.property("transitionDirection", Property.Type.Word, "Only available for Slide transition. Indicates the start direction for transition", "Slide", "Fade", "Grow", "Zoom").facets(Arrays.asList("Animated")));
    }

    @Override
    protected void addMethods() {
        super.addMethods();
        this.addMethod(Model.method("value", Collections.emptyList(), "Returns the badge value", "Integer").facets(Collections.singletonList("Badge")));
        this.addMethod(Model.method("update", Collections.singletonList(Model.methodParameter("value", "Integer")), "Updates the value for badge", "void").facets(Collections.singletonList("Badge")));
        this.addMethod(Model.method("isVisible", Collections.emptyList(), "Indicates if conditional block is visible", "Bool").facets(Collections.singletonList("Conditional")));
        this.addMethod(Model.method("isHidden", Collections.emptyList(), "Indicates if conditional block is hidden", "Bool").facets(Collections.singletonList("Conditional")));
        this.addMethod(Model.method("visible", Collections.singletonList(Model.methodParameter("value", "Bool")), "Sets if conditional block is visible or not", "Void").facets(Collections.singletonList("Conditional")));
        this.addMethod(Model.method("hidden", Collections.singletonList(Model.methodParameter("value", "Bool")), "Sets if conditional block is hidden or not", "Void").facets(Collections.singletonList("Conditional")));
        this.addMethod(Model.method("show", Collections.emptyList(), "Shows the conditional block", "Void").facets(Collections.singletonList("Conditional")));
        this.addMethod(Model.method("hide", Collections.emptyList(), "Hides the conditional block", "Void").facets(Collections.singletonList("Conditional")));
    }

    @Override
    protected void addEvents() {
        super.addEvents();
        this.addEvent(Model.method("onShow", Collections.singletonList(Model.methodParameter("listener", "io.intino.alexandria.ui.displays.events.ShowListener")), "This event is fired when conditional block is shown", "void").facets(Collections.singletonList("Conditional")));
        this.addEvent(Model.method("onHide", Collections.singletonList(Model.methodParameter("listener", "io.intino.alexandria.ui.displays.events.HideListener")), "This event is fired when conditional block is hidden", "void").facets(Collections.singletonList("Conditional")));
    }

    private String[] layoutOptions() {
        return new String[]{"Horizontal", "HorizontalReverse", "Vertical", "VerticalReverse", "Center", "CenterJustified", "CenterCenter", "Flexible", "Justified", "StartJustified", "EndJustified", "AroundJustified", "Wrap", "NoWrap", "WrapReverse"};
    }

    private String[] spacingOptions() {
        return new String[]{"DP8", "DP16", "DP24", "DP32", "DP40", "None"};
    }
}

