package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.WizardNavigator;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UIMessage;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class WizardNavigatorPushRequester extends io.intino.alexandria.ui.displays.requesters.ComponentPushRequester {

	public void execute(UIClient client, UIMessage message) {
		WizardNavigator display = display(client, message);
		if (display == null) return;
		String operation = operation(message);
		String data = data(message);

		if (operation.equals("back")) {
			display.back();
			return;
		}
		else if (operation.equals("select")) {
			display.select(Integer.parseInt(data));
			return;
		}
		else if (operation.equals("next")) {
			display.next();
			return;
		}
		else if (operation.equals("finish")) {
			display.finish();
			return;
		}

		super.execute(client, message);
	}

}