package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.ProxyDisplay;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class ProxyDisplayRequester extends io.intino.alexandria.ui.displays.requesters.DisplayRequester {

	public ProxyDisplayRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		ProxyDisplay display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("connected")) {
			display.connected();
			return;
		}
		else if (operation.equals("ready")) {
			display.ready();
			return;
		}
		else if (operation.equals("notifyMessage")) {
			display.notifyMessage(manager.fromQuery("v"));
			return;
		}

		super.execute();
	}
}