/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components.chart;

import io.intino.alexandria.ui.displays.components.chart.DataframeColumn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Dataframe {
    private List<DataframeColumn> columns = new ArrayList<DataframeColumn>();
    private Map<DataframeColumn, List<Object>> values = new HashMap<DataframeColumn, List<Object>>();

    public Dataframe add(DataframeColumn column) {
        this.columns.add(column);
        return this;
    }

    public Dataframe add(String column) {
        this.add(new DataframeColumn().name(column));
        return this;
    }

    public Dataframe set(String columnName, List<Object> values) {
        DataframeColumn column = this.column(columnName);
        this.values.put(column, values.stream().map(v -> this.parse(column, v)).collect(Collectors.toList()));
        return this;
    }

    public Dataframe add(int columnPos, Object value) {
        return this.add(this.column(columnPos), value);
    }

    public Dataframe add(String columnName, Object value) {
        return this.add(this.column(columnName), value);
    }

    public Dataframe add(DataframeColumn column, Object value) {
        if (!this.values.containsKey(column)) {
            this.values.put(column, new ArrayList());
        }
        this.values.get(column).add(this.parse(column, value));
        return this;
    }

    public DataframeColumn column(String name) {
        return this.columns.stream().filter(c -> c.name.equals(name)).findFirst().orElse(null);
    }

    public DataframeColumn column(int pos) {
        return this.columns.get(pos);
    }

    private Object parse(DataframeColumn column, Object value) {
        if (!(value instanceof String)) {
            return value;
        }
        if (column.type == DataframeColumn.Type.Double) {
            return Double.parseDouble((String)value);
        }
        if (column.type == DataframeColumn.Type.Integer) {
            return Integer.parseInt((String)value);
        }
        return value;
    }
}

