package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.Chat;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UIMessage;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class ChatPushRequester extends io.intino.alexandria.ui.displays.requesters.ComponentPushRequester {

	public void execute(UIClient client, UIMessage message) {
		Chat display = display(client, message);
		if (display == null) return;
		String operation = operation(message);
		String data = data(message);

		if (operation.equals("executeOperation")) {
			display.executeOperation(data);
			return;
		}
		else if (operation.equals("sendMessage")) {
			display.sendMessage(io.intino.alexandria.Json.fromString(data, io.intino.alexandria.schemas.ChatSendMessageInfo.class));
			return;
		}
		else if (operation.equals("sendAttachment")) {
			display.sendAttachment(data);
			return;
		}
		else if (operation.equals("previousMessages")) {
			display.previousMessages();
			return;
		}

		super.execute(client, message);
	}

}