package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.User;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class UserRequester extends io.intino.alexandria.ui.displays.requesters.ComponentRequester {

	public UserRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		User display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("logout")) {
			display.logout();
			return;
		}
		else if (operation.equals("refreshChildren")) {
			display.refreshChildren();
			return;
		}

		super.execute();
	}
}