package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.SelectorToggleBox;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class SelectorToggleBoxRequester extends BaseSelectorRequester {

	public SelectorToggleBoxRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		SelectorToggleBox display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("updateSelection")) {
			display.updateSelection(java.util.List.of(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), String[].class)));
			return;
		}

		super.execute();
	}
}