package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.Grid;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class GridRequester extends PageCollectionRequester {

	public GridRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		Grid display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("sort")) {
			display.sort(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.GridSortInfo.class));
			return;
		}
		else if (operation.equals("updateGroupByOptions")) {
			display.updateGroupByOptions(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.GridGroupByOptionsInfo.class));
			return;
		}
		else if (operation.equals("groupBy")) {
			display.groupBy(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.GridGroupByInfo.class));
			return;
		}
		else if (operation.equals("cellClick")) {
			display.cellClick(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.GridCellInfo.class));
			return;
		}
		else if (operation.equals("updateVisibleColumns")) {
			display.updateVisibleColumns(java.util.List.of(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.GridColumn[].class)));
			return;
		}
		else if (operation.equals("updateState")) {
			display.updateState(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.GridState.class));
			return;
		}

		super.execute();
	}
}