package io.intino.alexandria.ui;
import io.intino.alexandria.ui.displays.*;
import io.intino.alexandria.ui.displays.notifiers.*;
import io.intino.alexandria.ui.displays.requesters.*;
import io.intino.alexandria.ui.resources.*;
import io.intino.alexandria.UiFrameworkBox;
import io.intino.alexandria.UiFrameworkConfiguration;

import io.intino.alexandria.ui.AlexandriaUiServer;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifier;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.displays.DisplayRouteDispatcher;
import io.intino.alexandria.ui.resources.AssetResourceLoader;
import io.intino.alexandria.ui.services.push.PushService;
import io.intino.alexandria.ui.server.resources.AfterDisplayRequest;
import io.intino.alexandria.ui.server.resources.AssetResource;
import io.intino.alexandria.ui.server.resources.AuthenticateCallbackResource;
import io.intino.alexandria.ui.server.resources.BeforeDisplayRequest;

import java.net.MalformedURLException;
import java.net.URL;

public class UiElementsService extends io.intino.alexandria.ui.UI {

	public static void init(AlexandriaUiServer server, UiFrameworkBox box, PushService pushService, DisplayRouteDispatcher routeDispatcher) {
		UiFrameworkConfiguration configuration = (UiFrameworkConfiguration) box.configuration();
		box.routeManager(routeManager(server, routeDispatcher));
        server.route("/_alexandria/push").register(pushService);
        server.route("/authenticate-callback").get(manager -> new AuthenticateCallbackResource(manager, notifierProvider()).execute());
        server.route("/authenticate-callback/").get(manager -> new AuthenticateCallbackResource(manager, notifierProvider()).execute());
        server.route("/asset/:name").get(manager -> new AssetResource(name -> new AssetResourceLoader(box).load(name), manager, notifierProvider()).execute());
		server.route("/").get(manager -> new HomeResource(box, manager, notifierProvider()).execute());
		server.route("/widgets").get(manager -> new WidgetsResource(box, manager, notifierProvider()).execute());
		server.route("/widgets/:type/").get(manager -> new WidgetTypeResource(box, manager, notifierProvider()).execute());
		server.route("/widgets/microsite/:page").get(manager -> new MicroSiteResource(box, manager, notifierProvider()).execute());
		server.route("/static/example.html").get(manager -> new ExampleContentResource(box, manager, notifierProvider()).execute());
		initExposedDisplays(box, server, pushService);
		initProxyDisplays(box, server, pushService);
		initDisplays(server, pushService);
	}

	public static void initExposedDisplays(io.intino.alexandria.ui.AlexandriaUiBox box, AlexandriaUiServer server, PushService pushService) {

	}

	public static void initProxyDisplays(io.intino.alexandria.ui.AlexandriaUiBox box, AlexandriaUiServer server, PushService pushService) {

	}

	public static void initDisplays(AlexandriaUiServer server, PushService pushService) {
		initChatExamplesMold(server, pushService);
		initGroupingToolbarExamplesMold(server, pushService);
		initCollection(server, pushService);
		initPageCollection(server, pushService);
		initDynamicTable(server, pushService);
		initMap(server, pushService);
		initList(server, pushService);
		initTable(server, pushService);
		initMagazine(server, pushService);
		initGrid(server, pushService);
		initItem(server, pushService);
		initHeading(server, pushService);
		initRow(server, pushService);
		initBaseGrouping(server, pushService);
		initGrouping(server, pushService);
		initGroupingComboBox(server, pushService);
		initGroupingToolbar(server, pushService);
		initBaseSorting(server, pushService);
		initSorting(server, pushService);
		initSortingOrderBy(server, pushService);
		initSearchBox(server, pushService);
		initDownloadSelectionExamplesMold(server, pushService);
		initReelExamplesMold(server, pushService);
		initItemMold(server, pushService);
		initDigitalSignatureExamplesMold(server, pushService);
		initDateExamplesMold(server, pushService);
		initMultipleExamplesMold(server, pushService);
		initMultiple2Template(server, pushService);
		initLocationExamplesMold(server, pushService);
		initDynamicTableExamplesMold(server, pushService);
		initNumberExamplesMold(server, pushService);
		initWidgetTypeTemplate(server, pushService);
		initDownloadExamplesMold(server, pushService);
		initExportExamplesMold(server, pushService);
		initWizardExamplesMold(server, pushService);
		initTableExamplesMold(server, pushService);
		initSortingExamplesMold(server, pushService);
		initUserExamplesMold(server, pushService);
		initImageExamplesMold(server, pushService);
		initDashboardExamplesMold(server, pushService);
		initBlockExamplesMold(server, pushService);
		initTimelineExamplesMold(server, pushService);
		initSelectorExamplesMold(server, pushService);
		initGridExamplesMold(server, pushService);
		initSliderExamplesMold(server, pushService);
		initGroupingExamplesMold(server, pushService);
		initUploadExamplesMold(server, pushService);
		initToolbar(server, pushService);
		initActionable(server, pushService);
		initAction(server, pushService);
		initActionSplit(server, pushService);
		initActionSwitch(server, pushService);
		initActionToggle(server, pushService);
		initExport(server, pushService);
		initDownload(server, pushService);
		initUpload(server, pushService);
		initOpenPage(server, pushService);
		initOpenSite(server, pushService);
		initOpenBlock(server, pushService);
		initCloseBlock(server, pushService);
		initOpenDialog(server, pushService);
		initOpenLayer(server, pushService);
		initCloseLayer(server, pushService);
		initOpenPopover(server, pushService);
		initCloseDialog(server, pushService);
		initOpenDrawer(server, pushService);
		initCloseDrawer(server, pushService);
		initSelectNextItem(server, pushService);
		initSelectPreviousItem(server, pushService);
		initBaseSelectionAction(server, pushService);
		initSelectionAction(server, pushService);
		initDownloadSelection(server, pushService);
		initCopyToClipboard(server, pushService);
		initSetDarkMode(server, pushService);
		initSetLightMode(server, pushService);
		initSignAction(server, pushService);
		initAuthenticate(server, pushService);
		initSignText(server, pushService);
		initSignDocument(server, pushService);
		initEventlineExamplesMold(server, pushService);
		initSearchBoxExamplesMold(server, pushService);
		initAppDirectoryExamplesMold(server, pushService);
		initDateNavigatorExamplesMold(server, pushService);
		initFrameExamplesMold(server, pushService);
		initFileExamplesMold(server, pushService);
		initListExamplesMold(server, pushService);
		initDocsTemplate(server, pushService);
		initMobileDocsTemplate(server, pushService);
		initWidgetSummaryMold(server, pushService);
		initWidgetSummaryMoldCard(server, pushService);
		initChartExamplesMold(server, pushService);
		initKpiExamplesMold(server, pushService);
		initDialogExamplesMold(server, pushService);
		initDesktop(server, pushService);
		initPage(server, pushService);
		initPageDisplay(server, pushService);
		initDisplayRouter(server, pushService);
		initProxyDisplay(server, pushService);
		initTemplate(server, pushService);
		initBlock(server, pushService);
		initBlockConditional(server, pushService);
		initBlockSplitter(server, pushService);
		initBlockResizable(server, pushService);
		initBlockParallax(server, pushService);
		initBlockBadge(server, pushService);
		initBlockDrawer(server, pushService);
		initBlockPopover(server, pushService);
		initOption(server, pushService);
		initChart(server, pushService);
		initBaseDashboard(server, pushService);
		initDashboardShiny(server, pushService);
		initDashboardMetabase(server, pushService);
		initHeader(server, pushService);
		initTabs(server, pushService);
		initTab(server, pushService);
		initChat(server, pushService);
		initBaseIcon(server, pushService);
		initIcon(server, pushService);
		initMaterialIcon(server, pushService);
		initAppDirectory(server, pushService);
		initOptionList(server, pushService);
		initBaseSelector(server, pushService);
		initSelectorMenu(server, pushService);
		initSelectorRadioBox(server, pushService);
		initSelectorCheckBox(server, pushService);
		initSelectorComboBox(server, pushService);
		initSelectorToggleBox(server, pushService);
		initSelectorListBox(server, pushService);
		initSelectorTabs(server, pushService);
		initSelectorCollectionBox(server, pushService);
		initMultiple(server, pushService);
		initMultipleImage(server, pushService);
		initSpinner(server, pushService);
		initBaseSlider(server, pushService);
		initSlider(server, pushService);
		initRangeSlider(server, pushService);
		initTemporalSlider(server, pushService);
		initTemplateStamp(server, pushService);
		initTemplateStampEditable(server, pushService);
		initExternalTemplateStamp(server, pushService);
		initLibraryTemplateStamp(server, pushService);
		initDisplayStamp(server, pushService);
		initMicroSite(server, pushService);
		initHtmlViewer(server, pushService);
		initDocumentEditor(server, pushService);
		initDocumentEditorCollabora(server, pushService);
		initDateNavigator(server, pushService);
		initTimeline(server, pushService);
		initEventline(server, pushService);
		initReel(server, pushService);
		initFrame(server, pushService);
		initBaseDialog(server, pushService);
		initDialog(server, pushService);
		initAlertDialog(server, pushService);
		initDecisionDialog(server, pushService);
		initCollectionDialog(server, pushService);
		initLayer(server, pushService);
		initDivider(server, pushService);
		initUser(server, pushService);
		initWizard(server, pushService);
		initWizardNavigator(server, pushService);
		initStep(server, pushService);
		initKpi(server, pushService);
		initLayerExamplesMold(server, pushService);
		initHtmlViewerExamplesMold(server, pushService);
		initDocumentEditorExamplesMold(server, pushService);
		initTextExamplesMold(server, pushService);
		initHomeTemplate(server, pushService);
		initActionableExamplesMold(server, pushService);
		initBaseNumber(server, pushService);
		initNumber(server, pushService);
		initNumberEditable(server, pushService);
		initBaseDate(server, pushService);
		initDate(server, pushService);
		initDateEditable(server, pushService);
		initBaseText(server, pushService);
		initText(server, pushService);
		initTextCode(server, pushService);
		initTextEditable(server, pushService);
		initTextEditableCode(server, pushService);
		initBaseFile(server, pushService);
		initFile(server, pushService);
		initFileEditable(server, pushService);
		initBaseImage(server, pushService);
		initImage(server, pushService);
		initImageAvatar(server, pushService);
		initImageEditable(server, pushService);
		initBaseLocation(server, pushService);
		initLocation(server, pushService);
		initLocationEditable(server, pushService);
		initMapExamplesMold(server, pushService);
		initMicroSiteExamplesMold(server, pushService);
		initWidgetMold(server, pushService);
		initPropertyMold(server, pushService);
		initMethodMold(server, pushService);
		initMethodParamMold(server, pushService);
		initEventsDisplay(server, pushService);
		initDividerExamplesMold(server, pushService);
		initGroupingToolbar1Mold(server, pushService);
		initDownloadSelectionMold(server, pushService);
		initDynFirstNameItem(server, pushService);
		initDynLastNameItem(server, pushService);
		initTable11Mold(server, pushService);
		initTable12Mold(server, pushService);
		initTable21Mold(server, pushService);
		initTable22Mold(server, pushService);
		initSorting1Mold(server, pushService);
		initSorting2Mold(server, pushService);
		initSelector8ListMold(server, pushService);
		initGrouping1Mold(server, pushService);
		initGrouping2Mold(server, pushService);
		initSearchBox1Mold(server, pushService);
		initList1Mold(server, pushService);
		initList3Mold(server, pushService);
		initList4Mold(server, pushService);
		initList5Mold(server, pushService);
		initWidgetListMold(server, pushService);
		initDialog4ListMold(server, pushService);
		initMap1Mold(server, pushService);
		initMap2Mold(server, pushService);
		initMap3Mold(server, pushService);
		initMap4Mold(server, pushService);
		initTable1Row(server, pushService);
		initTable2Row(server, pushService);
		initDynamicTable1Row(server, pushService);
		registerNotifiers();
	}

	private static void registerNotifiers() {
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.ChatExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.GroupingToolbarExamplesMold.class);
		register(CollectionNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Collection.class);
		register(PageCollectionNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.PageCollection.class);
		register(DynamicTableNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.DynamicTable.class);
		register(MapNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Map.class);
		register(ListNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.List.class);
		register(TableNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Table.class);
		register(MagazineNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Magazine.class);
		register(GridNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Grid.class);
		register(ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Item.class);
		register(HeadingNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Heading.class);
		register(RowNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Row.class);
		register(BaseGroupingNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseGrouping.class);
		register(GroupingNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Grouping.class);
		register(GroupingComboBoxNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.GroupingComboBox.class);
		register(GroupingToolbarNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.GroupingToolbar.class);
		register(BaseSortingNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseSorting.class);
		register(SortingNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Sorting.class);
		register(SortingOrderByNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SortingOrderBy.class);
		register(SearchBoxNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SearchBox.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.DownloadSelectionExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.ReelExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.ItemMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.DigitalSignatureExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.DateExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.MultipleExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.Multiple2Template.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.LocationExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.DynamicTableExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.NumberExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.WidgetTypeTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.DownloadExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.ExportExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.WizardExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.TableExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.SortingExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.UserExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.ImageExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.DashboardExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.BlockExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.TimelineExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.SelectorExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.GridExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.SliderExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.GroupingExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.UploadExamplesMold.class);
		register(ToolbarNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Toolbar.class);
		register(ActionableNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Actionable.class);
		register(ActionNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Action.class);
		register(ActionSplitNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.ActionSplit.class);
		register(ActionSwitchNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.ActionSwitch.class);
		register(ActionToggleNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.ActionToggle.class);
		register(ExportNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Export.class);
		register(DownloadNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Download.class);
		register(UploadNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Upload.class);
		register(OpenPageNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.OpenPage.class);
		register(OpenSiteNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.OpenSite.class);
		register(OpenBlockNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.OpenBlock.class);
		register(CloseBlockNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.CloseBlock.class);
		register(OpenDialogNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.OpenDialog.class);
		register(OpenLayerNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.OpenLayer.class);
		register(CloseLayerNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.CloseLayer.class);
		register(OpenPopoverNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.OpenPopover.class);
		register(CloseDialogNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.CloseDialog.class);
		register(OpenDrawerNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.OpenDrawer.class);
		register(CloseDrawerNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.CloseDrawer.class);
		register(SelectNextItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SelectNextItem.class);
		register(SelectPreviousItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SelectPreviousItem.class);
		register(BaseSelectionActionNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseSelectionAction.class);
		register(SelectionActionNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SelectionAction.class);
		register(DownloadSelectionNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.DownloadSelection.class);
		register(CopyToClipboardNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.CopyToClipboard.class);
		register(SetDarkModeNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SetDarkMode.class);
		register(SetLightModeNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SetLightMode.class);
		register(SignActionNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SignAction.class);
		register(AuthenticateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Authenticate.class);
		register(SignTextNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SignText.class);
		register(SignDocumentNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SignDocument.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.EventlineExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.SearchBoxExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.AppDirectoryExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.DateNavigatorExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.FrameExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.FileExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.ListExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.DocsTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.MobileDocsTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.WidgetSummaryMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.WidgetSummaryMoldCard.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.ChartExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.KpiExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.DialogExamplesMold.class);
		register(DesktopNotifier.class).forDisplay(io.intino.alexandria.ui.displays.Desktop.class);
		register(PageNotifier.class).forDisplay(io.intino.alexandria.ui.displays.Page.class);
		register(PageDisplayNotifier.class).forDisplay(io.intino.alexandria.ui.displays.PageDisplay.class);
		register(DisplayRouterNotifier.class).forDisplay(io.intino.alexandria.ui.displays.DisplayRouter.class);
		register(ProxyDisplayNotifier.class).forDisplay(io.intino.alexandria.ui.displays.ProxyDisplay.class);
		register(TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Template.class);
		register(BlockNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Block.class);
		register(BlockConditionalNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BlockConditional.class);
		register(BlockSplitterNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BlockSplitter.class);
		register(BlockResizableNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BlockResizable.class);
		register(BlockParallaxNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BlockParallax.class);
		register(BlockBadgeNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BlockBadge.class);
		register(BlockDrawerNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BlockDrawer.class);
		register(BlockPopoverNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BlockPopover.class);
		register(OptionNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Option.class);
		register(ChartNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Chart.class);
		register(BaseDashboardNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseDashboard.class);
		register(DashboardShinyNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.DashboardShiny.class);
		register(DashboardMetabaseNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.DashboardMetabase.class);
		register(HeaderNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Header.class);
		register(TabsNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Tabs.class);
		register(TabNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Tab.class);
		register(ChatNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Chat.class);
		register(BaseIconNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseIcon.class);
		register(IconNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Icon.class);
		register(MaterialIconNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.MaterialIcon.class);
		register(AppDirectoryNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.AppDirectory.class);
		register(OptionListNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.OptionList.class);
		register(BaseSelectorNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseSelector.class);
		register(SelectorMenuNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SelectorMenu.class);
		register(SelectorRadioBoxNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SelectorRadioBox.class);
		register(SelectorCheckBoxNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SelectorCheckBox.class);
		register(SelectorComboBoxNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SelectorComboBox.class);
		register(SelectorToggleBoxNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SelectorToggleBox.class);
		register(SelectorListBoxNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SelectorListBox.class);
		register(SelectorTabsNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SelectorTabs.class);
		register(SelectorCollectionBoxNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SelectorCollectionBox.class);
		register(MultipleNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Multiple.class);
		register(MultipleImageNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.MultipleImage.class);
		register(SpinnerNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Spinner.class);
		register(BaseSliderNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseSlider.class);
		register(SliderNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Slider.class);
		register(RangeSliderNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.RangeSlider.class);
		register(TemporalSliderNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.TemporalSlider.class);
		register(TemplateStampNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.TemplateStamp.class);
		register(TemplateStampEditableNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.TemplateStampEditable.class);
		register(ExternalTemplateStampNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.ExternalTemplateStamp.class);
		register(LibraryTemplateStampNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.LibraryTemplateStamp.class);
		register(DisplayStampNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.DisplayStamp.class);
		register(MicroSiteNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.MicroSite.class);
		register(HtmlViewerNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.HtmlViewer.class);
		register(DocumentEditorNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.DocumentEditor.class);
		register(DocumentEditorCollaboraNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.DocumentEditorCollabora.class);
		register(DateNavigatorNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.DateNavigator.class);
		register(TimelineNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Timeline.class);
		register(EventlineNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Eventline.class);
		register(ReelNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Reel.class);
		register(FrameNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Frame.class);
		register(BaseDialogNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseDialog.class);
		register(DialogNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Dialog.class);
		register(AlertDialogNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.AlertDialog.class);
		register(DecisionDialogNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.DecisionDialog.class);
		register(CollectionDialogNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.CollectionDialog.class);
		register(LayerNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Layer.class);
		register(DividerNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Divider.class);
		register(UserNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.User.class);
		register(WizardNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Wizard.class);
		register(WizardNavigatorNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.WizardNavigator.class);
		register(StepNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Step.class);
		register(KpiNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Kpi.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.LayerExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.HtmlViewerExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.DocumentEditorExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.TextExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.HomeTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.ActionableExamplesMold.class);
		register(BaseNumberNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseNumber.class);
		register(NumberNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Number.class);
		register(NumberEditableNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.NumberEditable.class);
		register(BaseDateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseDate.class);
		register(DateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Date.class);
		register(DateEditableNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.DateEditable.class);
		register(BaseTextNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseText.class);
		register(TextNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Text.class);
		register(TextCodeNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.TextCode.class);
		register(TextEditableNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.TextEditable.class);
		register(TextEditableCodeNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.TextEditableCode.class);
		register(BaseFileNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseFile.class);
		register(FileNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.File.class);
		register(FileEditableNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.FileEditable.class);
		register(BaseImageNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseImage.class);
		register(ImageNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Image.class);
		register(ImageAvatarNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.ImageAvatar.class);
		register(ImageEditableNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.ImageEditable.class);
		register(BaseLocationNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseLocation.class);
		register(LocationNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Location.class);
		register(LocationEditableNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.LocationEditable.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.MapExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.MicroSiteExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.WidgetMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.PropertyMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.MethodMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.MethodParamMold.class);
		register(EventsDisplayNotifier.class).forDisplay(io.intino.alexandria.ui.displays.EventsDisplay.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.DividerExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.GroupingToolbar1Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.DownloadSelectionMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.DynFirstNameItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.DynLastNameItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Table11Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Table12Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Table21Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Table22Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Sorting1Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Sorting2Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Selector8ListMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Grouping1Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Grouping2Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.SearchBox1Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.List1Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.List3Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.List4Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.List5Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.WidgetListMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Dialog4ListMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Map1Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Map2Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Map3Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Map4Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.RowNotifier.class).forDisplay(io.intino.alexandria.ui.displays.rows.Table1Row.class);
		register(io.intino.alexandria.ui.displays.notifiers.RowNotifier.class).forDisplay(io.intino.alexandria.ui.displays.rows.Table2Row.class);
		register(io.intino.alexandria.ui.displays.notifiers.RowNotifier.class).forDisplay(io.intino.alexandria.ui.displays.rows.DynamicTable1Row.class);
	}

	private static void initChatExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/chatexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/chatexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/chatexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("chatexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initGroupingToolbarExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/groupingtoolbarexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/groupingtoolbarexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/groupingtoolbarexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("groupingtoolbarexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initCollection(AlexandriaUiServer server, PushService pushService) {
		server.route("/collection/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/collection/:displayId").post(manager -> new CollectionRequester(manager, notifierProvider()).execute());
		server.route("/collection/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("collection", new CollectionPushRequester());

	}
	private static void initPageCollection(AlexandriaUiServer server, PushService pushService) {
		server.route("/pagecollection/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/pagecollection/:displayId").post(manager -> new PageCollectionRequester(manager, notifierProvider()).execute());
		server.route("/pagecollection/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("pagecollection", new PageCollectionPushRequester());

	}
	private static void initDynamicTable(AlexandriaUiServer server, PushService pushService) {
		server.route("/dynamictable/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/dynamictable/:displayId").post(manager -> new DynamicTableRequester(manager, notifierProvider()).execute());
		server.route("/dynamictable/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dynamictable", new DynamicTablePushRequester());

	}
	private static void initMap(AlexandriaUiServer server, PushService pushService) {
		server.route("/map/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/map/:displayId").post(manager -> new MapRequester(manager, notifierProvider()).execute());
		server.route("/map/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("map", new MapPushRequester());

	}
	private static void initList(AlexandriaUiServer server, PushService pushService) {
		server.route("/list/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/list/:displayId").post(manager -> new ListRequester(manager, notifierProvider()).execute());
		server.route("/list/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("list", new ListPushRequester());

	}
	private static void initTable(AlexandriaUiServer server, PushService pushService) {
		server.route("/table/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/table/:displayId").post(manager -> new TableRequester(manager, notifierProvider()).execute());
		server.route("/table/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("table", new TablePushRequester());

	}
	private static void initMagazine(AlexandriaUiServer server, PushService pushService) {
		server.route("/magazine/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/magazine/:displayId").post(manager -> new MagazineRequester(manager, notifierProvider()).execute());
		server.route("/magazine/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("magazine", new MagazinePushRequester());

	}
	private static void initGrid(AlexandriaUiServer server, PushService pushService) {
		server.route("/grid/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/grid/:displayId").post(manager -> new GridRequester(manager, notifierProvider()).execute());
		server.route("/grid/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("grid", new GridPushRequester());

	}
	private static void initItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/item/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/item/:displayId").post(manager -> new ItemRequester(manager, notifierProvider()).execute());
		server.route("/item/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("item", new ItemPushRequester());

	}
	private static void initHeading(AlexandriaUiServer server, PushService pushService) {
		server.route("/heading/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/heading/:displayId").post(manager -> new HeadingRequester(manager, notifierProvider()).execute());
		server.route("/heading/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("heading", new HeadingPushRequester());

	}
	private static void initRow(AlexandriaUiServer server, PushService pushService) {
		server.route("/row/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/row/:displayId").post(manager -> new RowRequester(manager, notifierProvider()).execute());
		server.route("/row/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("row", new RowPushRequester());

	}
	private static void initBaseGrouping(AlexandriaUiServer server, PushService pushService) {
		server.route("/basegrouping/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/basegrouping/:displayId").post(manager -> new BaseGroupingRequester(manager, notifierProvider()).execute());
		server.route("/basegrouping/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("basegrouping", new BaseGroupingPushRequester());

	}
	private static void initGrouping(AlexandriaUiServer server, PushService pushService) {
		server.route("/grouping/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/grouping/:displayId").post(manager -> new GroupingRequester(manager, notifierProvider()).execute());
		server.route("/grouping/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("grouping", new GroupingPushRequester());

	}
	private static void initGroupingComboBox(AlexandriaUiServer server, PushService pushService) {
		server.route("/groupingcombobox/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/groupingcombobox/:displayId").post(manager -> new GroupingComboBoxRequester(manager, notifierProvider()).execute());
		server.route("/groupingcombobox/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("groupingcombobox", new GroupingComboBoxPushRequester());

	}
	private static void initGroupingToolbar(AlexandriaUiServer server, PushService pushService) {
		server.route("/groupingtoolbar/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/groupingtoolbar/:displayId").post(manager -> new GroupingToolbarRequester(manager, notifierProvider()).execute());
		server.route("/groupingtoolbar/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("groupingtoolbar", new GroupingToolbarPushRequester());

	}
	private static void initBaseSorting(AlexandriaUiServer server, PushService pushService) {
		server.route("/basesorting/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/basesorting/:displayId").post(manager -> new BaseSortingRequester(manager, notifierProvider()).execute());
		server.route("/basesorting/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("basesorting", new BaseSortingPushRequester());

	}
	private static void initSorting(AlexandriaUiServer server, PushService pushService) {
		server.route("/sorting/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/sorting/:displayId").post(manager -> new SortingRequester(manager, notifierProvider()).execute());
		server.route("/sorting/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("sorting", new SortingPushRequester());

	}
	private static void initSortingOrderBy(AlexandriaUiServer server, PushService pushService) {
		server.route("/sortingorderby/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/sortingorderby/:displayId").post(manager -> new SortingOrderByRequester(manager, notifierProvider()).execute());
		server.route("/sortingorderby/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("sortingorderby", new SortingOrderByPushRequester());

	}
	private static void initSearchBox(AlexandriaUiServer server, PushService pushService) {
		server.route("/searchbox/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/searchbox/:displayId").post(manager -> new SearchBoxRequester(manager, notifierProvider()).execute());
		server.route("/searchbox/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("searchbox", new SearchBoxPushRequester());

	}
	private static void initDownloadSelectionExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/downloadselectionexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/downloadselectionexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/downloadselectionexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("downloadselectionexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initReelExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/reelexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/reelexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/reelexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("reelexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initItemMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/itemmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/itemmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/itemmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("itemmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initDigitalSignatureExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/digitalsignatureexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/digitalsignatureexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/digitalsignatureexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("digitalsignatureexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initDateExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/dateexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/dateexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/dateexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dateexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initMultipleExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/multipleexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/multipleexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/multipleexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("multipleexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initMultiple2Template(AlexandriaUiServer server, PushService pushService) {
		server.route("/multiple2template/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/multiple2template/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/multiple2template/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("multiple2template", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initLocationExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/locationexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/locationexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/locationexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("locationexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initDynamicTableExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/dynamictableexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/dynamictableexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/dynamictableexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dynamictableexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initNumberExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/numberexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/numberexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/numberexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("numberexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initWidgetTypeTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/widgettypetemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/widgettypetemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/widgettypetemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("widgettypetemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initDownloadExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/downloadexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/downloadexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/downloadexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("downloadexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initExportExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/exportexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/exportexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/exportexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("exportexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initWizardExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/wizardexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/wizardexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/wizardexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("wizardexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTableExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/tableexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/tableexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/tableexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("tableexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initSortingExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/sortingexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/sortingexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/sortingexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("sortingexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initUserExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/userexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/userexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/userexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("userexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initImageExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/imageexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/imageexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/imageexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("imageexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initDashboardExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/dashboardexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/dashboardexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/dashboardexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dashboardexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initBlockExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/blockexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/blockexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/blockexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("blockexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTimelineExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/timelineexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/timelineexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/timelineexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("timelineexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initSelectorExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/selectorexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/selectorexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/selectorexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selectorexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initGridExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/gridexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/gridexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/gridexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("gridexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initSliderExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/sliderexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/sliderexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/sliderexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("sliderexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initGroupingExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/groupingexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/groupingexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/groupingexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("groupingexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initUploadExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/uploadexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/uploadexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/uploadexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("uploadexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initToolbar(AlexandriaUiServer server, PushService pushService) {
		server.route("/toolbar/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/toolbar/:displayId").post(manager -> new ToolbarRequester(manager, notifierProvider()).execute());
		server.route("/toolbar/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("toolbar", new ToolbarPushRequester());

	}
	private static void initActionable(AlexandriaUiServer server, PushService pushService) {
		server.route("/actionable/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/actionable/:displayId").post(manager -> new ActionableRequester(manager, notifierProvider()).execute());
		server.route("/actionable/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("actionable", new ActionablePushRequester());

	}
	private static void initAction(AlexandriaUiServer server, PushService pushService) {
		server.route("/action/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/action/:displayId").post(manager -> new ActionRequester(manager, notifierProvider()).execute());
		server.route("/action/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("action", new ActionPushRequester());

	}
	private static void initActionSplit(AlexandriaUiServer server, PushService pushService) {
		server.route("/actionsplit/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/actionsplit/:displayId").post(manager -> new ActionSplitRequester(manager, notifierProvider()).execute());
		server.route("/actionsplit/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("actionsplit", new ActionSplitPushRequester());

	}
	private static void initActionSwitch(AlexandriaUiServer server, PushService pushService) {
		server.route("/actionswitch/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/actionswitch/:displayId").post(manager -> new ActionSwitchRequester(manager, notifierProvider()).execute());
		server.route("/actionswitch/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("actionswitch", new ActionSwitchPushRequester());

	}
	private static void initActionToggle(AlexandriaUiServer server, PushService pushService) {
		server.route("/actiontoggle/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/actiontoggle/:displayId").post(manager -> new ActionToggleRequester(manager, notifierProvider()).execute());
		server.route("/actiontoggle/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("actiontoggle", new ActionTogglePushRequester());

	}
	private static void initExport(AlexandriaUiServer server, PushService pushService) {
		server.route("/export/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/export/:displayId").post(manager -> new ExportRequester(manager, notifierProvider()).execute());
		server.route("/export/:displayId").get(manager -> new ExportRequester(manager, notifierProvider()).execute());
		server.route("/export/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("export", new ExportPushRequester());

	}
	private static void initDownload(AlexandriaUiServer server, PushService pushService) {
		server.route("/download/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/download/:displayId").post(manager -> new DownloadRequester(manager, notifierProvider()).execute());
		server.route("/download/:displayId").get(manager -> new DownloadRequester(manager, notifierProvider()).execute());
		server.route("/download/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("download", new DownloadPushRequester());

	}
	private static void initUpload(AlexandriaUiServer server, PushService pushService) {
		server.route("/upload/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/upload/:displayId").post(manager -> new UploadRequester(manager, notifierProvider()).execute());
		server.route("/upload/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("upload", new UploadPushRequester());

	}
	private static void initOpenPage(AlexandriaUiServer server, PushService pushService) {
		server.route("/openpage/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/openpage/:displayId").post(manager -> new OpenPageRequester(manager, notifierProvider()).execute());
		server.route("/openpage/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("openpage", new OpenPagePushRequester());

	}
	private static void initOpenSite(AlexandriaUiServer server, PushService pushService) {
		server.route("/opensite/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/opensite/:displayId").post(manager -> new OpenSiteRequester(manager, notifierProvider()).execute());
		server.route("/opensite/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("opensite", new OpenSitePushRequester());

	}
	private static void initOpenBlock(AlexandriaUiServer server, PushService pushService) {
		server.route("/openblock/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/openblock/:displayId").post(manager -> new OpenBlockRequester(manager, notifierProvider()).execute());
		server.route("/openblock/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("openblock", new OpenBlockPushRequester());

	}
	private static void initCloseBlock(AlexandriaUiServer server, PushService pushService) {
		server.route("/closeblock/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/closeblock/:displayId").post(manager -> new CloseBlockRequester(manager, notifierProvider()).execute());
		server.route("/closeblock/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("closeblock", new CloseBlockPushRequester());

	}
	private static void initOpenDialog(AlexandriaUiServer server, PushService pushService) {
		server.route("/opendialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/opendialog/:displayId").post(manager -> new OpenDialogRequester(manager, notifierProvider()).execute());
		server.route("/opendialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("opendialog", new OpenDialogPushRequester());

	}
	private static void initOpenLayer(AlexandriaUiServer server, PushService pushService) {
		server.route("/openlayer/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/openlayer/:displayId").post(manager -> new OpenLayerRequester(manager, notifierProvider()).execute());
		server.route("/openlayer/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("openlayer", new OpenLayerPushRequester());

	}
	private static void initCloseLayer(AlexandriaUiServer server, PushService pushService) {
		server.route("/closelayer/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/closelayer/:displayId").post(manager -> new CloseLayerRequester(manager, notifierProvider()).execute());
		server.route("/closelayer/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("closelayer", new CloseLayerPushRequester());

	}
	private static void initOpenPopover(AlexandriaUiServer server, PushService pushService) {
		server.route("/openpopover/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/openpopover/:displayId").post(manager -> new OpenPopoverRequester(manager, notifierProvider()).execute());
		server.route("/openpopover/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("openpopover", new OpenPopoverPushRequester());

	}
	private static void initCloseDialog(AlexandriaUiServer server, PushService pushService) {
		server.route("/closedialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/closedialog/:displayId").post(manager -> new CloseDialogRequester(manager, notifierProvider()).execute());
		server.route("/closedialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("closedialog", new CloseDialogPushRequester());

	}
	private static void initOpenDrawer(AlexandriaUiServer server, PushService pushService) {
		server.route("/opendrawer/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/opendrawer/:displayId").post(manager -> new OpenDrawerRequester(manager, notifierProvider()).execute());
		server.route("/opendrawer/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("opendrawer", new OpenDrawerPushRequester());

	}
	private static void initCloseDrawer(AlexandriaUiServer server, PushService pushService) {
		server.route("/closedrawer/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/closedrawer/:displayId").post(manager -> new CloseDrawerRequester(manager, notifierProvider()).execute());
		server.route("/closedrawer/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("closedrawer", new CloseDrawerPushRequester());

	}
	private static void initSelectNextItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/selectnextitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/selectnextitem/:displayId").post(manager -> new SelectNextItemRequester(manager, notifierProvider()).execute());
		server.route("/selectnextitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selectnextitem", new SelectNextItemPushRequester());

	}
	private static void initSelectPreviousItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/selectpreviousitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/selectpreviousitem/:displayId").post(manager -> new SelectPreviousItemRequester(manager, notifierProvider()).execute());
		server.route("/selectpreviousitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selectpreviousitem", new SelectPreviousItemPushRequester());

	}
	private static void initBaseSelectionAction(AlexandriaUiServer server, PushService pushService) {
		server.route("/baseselectionaction/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/baseselectionaction/:displayId").post(manager -> new BaseSelectionActionRequester(manager, notifierProvider()).execute());
		server.route("/baseselectionaction/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("baseselectionaction", new BaseSelectionActionPushRequester());

	}
	private static void initSelectionAction(AlexandriaUiServer server, PushService pushService) {
		server.route("/selectionaction/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/selectionaction/:displayId").post(manager -> new SelectionActionRequester(manager, notifierProvider()).execute());
		server.route("/selectionaction/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selectionaction", new SelectionActionPushRequester());

	}
	private static void initDownloadSelection(AlexandriaUiServer server, PushService pushService) {
		server.route("/downloadselection/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/downloadselection/:displayId").post(manager -> new DownloadSelectionRequester(manager, notifierProvider()).execute());
		server.route("/downloadselection/:displayId").get(manager -> new DownloadSelectionRequester(manager, notifierProvider()).execute());
		server.route("/downloadselection/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("downloadselection", new DownloadSelectionPushRequester());

	}
	private static void initCopyToClipboard(AlexandriaUiServer server, PushService pushService) {
		server.route("/copytoclipboard/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/copytoclipboard/:displayId").post(manager -> new CopyToClipboardRequester(manager, notifierProvider()).execute());
		server.route("/copytoclipboard/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("copytoclipboard", new CopyToClipboardPushRequester());

	}
	private static void initSetDarkMode(AlexandriaUiServer server, PushService pushService) {
		server.route("/setdarkmode/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/setdarkmode/:displayId").post(manager -> new SetDarkModeRequester(manager, notifierProvider()).execute());
		server.route("/setdarkmode/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("setdarkmode", new SetDarkModePushRequester());

	}
	private static void initSetLightMode(AlexandriaUiServer server, PushService pushService) {
		server.route("/setlightmode/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/setlightmode/:displayId").post(manager -> new SetLightModeRequester(manager, notifierProvider()).execute());
		server.route("/setlightmode/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("setlightmode", new SetLightModePushRequester());

	}
	private static void initSignAction(AlexandriaUiServer server, PushService pushService) {
		server.route("/signaction/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/signaction/:displayId").post(manager -> new SignActionRequester(manager, notifierProvider()).execute());
		server.route("/signaction/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("signaction", new SignActionPushRequester());

	}
	private static void initAuthenticate(AlexandriaUiServer server, PushService pushService) {
		server.route("/authenticate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/authenticate/:displayId").post(manager -> new AuthenticateRequester(manager, notifierProvider()).execute());
		server.route("/authenticate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("authenticate", new AuthenticatePushRequester());

	}
	private static void initSignText(AlexandriaUiServer server, PushService pushService) {
		server.route("/signtext/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/signtext/:displayId").post(manager -> new SignTextRequester(manager, notifierProvider()).execute());
		server.route("/signtext/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("signtext", new SignTextPushRequester());

	}
	private static void initSignDocument(AlexandriaUiServer server, PushService pushService) {
		server.route("/signdocument/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/signdocument/:displayId").post(manager -> new SignDocumentRequester(manager, notifierProvider()).execute());
		server.route("/signdocument/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("signdocument", new SignDocumentPushRequester());

	}
	private static void initEventlineExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/eventlineexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/eventlineexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/eventlineexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("eventlineexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initSearchBoxExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/searchboxexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/searchboxexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/searchboxexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("searchboxexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initAppDirectoryExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/appdirectoryexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/appdirectoryexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/appdirectoryexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("appdirectoryexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initDateNavigatorExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/datenavigatorexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/datenavigatorexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/datenavigatorexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("datenavigatorexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initFrameExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/frameexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/frameexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/frameexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("frameexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initFileExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/fileexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/fileexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/fileexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("fileexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initListExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/listexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/listexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/listexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("listexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initDocsTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/docstemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/docstemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/docstemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("docstemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initMobileDocsTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/mobiledocstemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/mobiledocstemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/mobiledocstemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("mobiledocstemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initWidgetSummaryMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/widgetsummarymold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/widgetsummarymold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/widgetsummarymold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("widgetsummarymold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initWidgetSummaryMoldCard(AlexandriaUiServer server, PushService pushService) {
		server.route("/widgetsummarymoldcard/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/widgetsummarymoldcard/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/widgetsummarymoldcard/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("widgetsummarymoldcard", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initChartExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/chartexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/chartexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/chartexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("chartexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initKpiExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/kpiexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/kpiexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/kpiexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("kpiexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initDialogExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/dialogexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/dialogexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/dialogexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dialogexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initDesktop(AlexandriaUiServer server, PushService pushService) {
		server.route("/desktop/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/desktop/:displayId").post(manager -> new DesktopRequester(manager, notifierProvider()).execute());
		server.route("/desktop/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("desktop", new DesktopPushRequester());

	}
	private static void initPage(AlexandriaUiServer server, PushService pushService) {
		server.route("/page/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/page/:displayId").post(manager -> new PageRequester(manager, notifierProvider()).execute());
		server.route("/page/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("page", new PagePushRequester());

	}
	private static void initPageDisplay(AlexandriaUiServer server, PushService pushService) {
		server.route("/pagedisplay/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/pagedisplay/:displayId").post(manager -> new PageDisplayRequester(manager, notifierProvider()).execute());
		server.route("/pagedisplay/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("pagedisplay", new PageDisplayPushRequester());

	}
	private static void initDisplayRouter(AlexandriaUiServer server, PushService pushService) {
		server.route("/displayrouter/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/displayrouter/:displayId").post(manager -> new DisplayRouterRequester(manager, notifierProvider()).execute());
		server.route("/displayrouter/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("displayrouter", new DisplayRouterPushRequester());

	}
	private static void initProxyDisplay(AlexandriaUiServer server, PushService pushService) {
		server.route("/proxydisplay/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/proxydisplay/:displayId").post(manager -> new ProxyDisplayRequester(manager, notifierProvider()).execute());
		server.route("/proxydisplay/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("proxydisplay", new ProxyDisplayPushRequester());

	}
	private static void initTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/template/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/template/:displayId").post(manager -> new TemplateRequester(manager, notifierProvider()).execute());
		server.route("/template/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("template", new TemplatePushRequester());

	}
	private static void initBlock(AlexandriaUiServer server, PushService pushService) {
		server.route("/block/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/block/:displayId").post(manager -> new BlockRequester(manager, notifierProvider()).execute());
		server.route("/block/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("block", new BlockPushRequester());

	}
	private static void initBlockConditional(AlexandriaUiServer server, PushService pushService) {
		server.route("/blockconditional/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/blockconditional/:displayId").post(manager -> new BlockConditionalRequester(manager, notifierProvider()).execute());
		server.route("/blockconditional/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("blockconditional", new BlockConditionalPushRequester());

	}
	private static void initBlockSplitter(AlexandriaUiServer server, PushService pushService) {
		server.route("/blocksplitter/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/blocksplitter/:displayId").post(manager -> new BlockSplitterRequester(manager, notifierProvider()).execute());
		server.route("/blocksplitter/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("blocksplitter", new BlockSplitterPushRequester());

	}
	private static void initBlockResizable(AlexandriaUiServer server, PushService pushService) {
		server.route("/blockresizable/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/blockresizable/:displayId").post(manager -> new BlockResizableRequester(manager, notifierProvider()).execute());
		server.route("/blockresizable/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("blockresizable", new BlockResizablePushRequester());

	}
	private static void initBlockParallax(AlexandriaUiServer server, PushService pushService) {
		server.route("/blockparallax/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/blockparallax/:displayId").post(manager -> new BlockParallaxRequester(manager, notifierProvider()).execute());
		server.route("/blockparallax/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("blockparallax", new BlockParallaxPushRequester());

	}
	private static void initBlockBadge(AlexandriaUiServer server, PushService pushService) {
		server.route("/blockbadge/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/blockbadge/:displayId").post(manager -> new BlockBadgeRequester(manager, notifierProvider()).execute());
		server.route("/blockbadge/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("blockbadge", new BlockBadgePushRequester());

	}
	private static void initBlockDrawer(AlexandriaUiServer server, PushService pushService) {
		server.route("/blockdrawer/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/blockdrawer/:displayId").post(manager -> new BlockDrawerRequester(manager, notifierProvider()).execute());
		server.route("/blockdrawer/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("blockdrawer", new BlockDrawerPushRequester());

	}
	private static void initBlockPopover(AlexandriaUiServer server, PushService pushService) {
		server.route("/blockpopover/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/blockpopover/:displayId").post(manager -> new BlockPopoverRequester(manager, notifierProvider()).execute());
		server.route("/blockpopover/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("blockpopover", new BlockPopoverPushRequester());

	}
	private static void initOption(AlexandriaUiServer server, PushService pushService) {
		server.route("/option/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/option/:displayId").post(manager -> new OptionRequester(manager, notifierProvider()).execute());
		server.route("/option/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("option", new OptionPushRequester());

	}
	private static void initChart(AlexandriaUiServer server, PushService pushService) {
		server.route("/chart/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/chart/:displayId").post(manager -> new ChartRequester(manager, notifierProvider()).execute());
		server.route("/chart/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("chart", new ChartPushRequester());

	}
	private static void initBaseDashboard(AlexandriaUiServer server, PushService pushService) {
		server.route("/basedashboard/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/basedashboard/:displayId").post(manager -> new BaseDashboardRequester(manager, notifierProvider()).execute());
		server.route("/basedashboard/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("basedashboard", new BaseDashboardPushRequester());

	}
	private static void initDashboardShiny(AlexandriaUiServer server, PushService pushService) {
		server.route("/dashboardshiny/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/dashboardshiny/:displayId").post(manager -> new DashboardShinyRequester(manager, notifierProvider()).execute());
		server.route("/dashboardshiny/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dashboardshiny", new DashboardShinyPushRequester());

	}
	private static void initDashboardMetabase(AlexandriaUiServer server, PushService pushService) {
		server.route("/dashboardmetabase/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/dashboardmetabase/:displayId").post(manager -> new DashboardMetabaseRequester(manager, notifierProvider()).execute());
		server.route("/dashboardmetabase/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dashboardmetabase", new DashboardMetabasePushRequester());

	}
	private static void initHeader(AlexandriaUiServer server, PushService pushService) {
		server.route("/header/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/header/:displayId").post(manager -> new HeaderRequester(manager, notifierProvider()).execute());
		server.route("/header/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("header", new HeaderPushRequester());

	}
	private static void initTabs(AlexandriaUiServer server, PushService pushService) {
		server.route("/tabs/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/tabs/:displayId").post(manager -> new TabsRequester(manager, notifierProvider()).execute());
		server.route("/tabs/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("tabs", new TabsPushRequester());

	}
	private static void initTab(AlexandriaUiServer server, PushService pushService) {
		server.route("/tab/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/tab/:displayId").post(manager -> new TabRequester(manager, notifierProvider()).execute());
		server.route("/tab/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("tab", new TabPushRequester());

	}
	private static void initChat(AlexandriaUiServer server, PushService pushService) {
		server.route("/chat/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/chat/:displayId").post(manager -> new ChatRequester(manager, notifierProvider()).execute());
		server.route("/chat/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("chat", new ChatPushRequester());

	}
	private static void initBaseIcon(AlexandriaUiServer server, PushService pushService) {
		server.route("/baseicon/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/baseicon/:displayId").post(manager -> new BaseIconRequester(manager, notifierProvider()).execute());
		server.route("/baseicon/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("baseicon", new BaseIconPushRequester());

	}
	private static void initIcon(AlexandriaUiServer server, PushService pushService) {
		server.route("/icon/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/icon/:displayId").post(manager -> new IconRequester(manager, notifierProvider()).execute());
		server.route("/icon/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("icon", new IconPushRequester());

	}
	private static void initMaterialIcon(AlexandriaUiServer server, PushService pushService) {
		server.route("/materialicon/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/materialicon/:displayId").post(manager -> new MaterialIconRequester(manager, notifierProvider()).execute());
		server.route("/materialicon/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("materialicon", new MaterialIconPushRequester());

	}
	private static void initAppDirectory(AlexandriaUiServer server, PushService pushService) {
		server.route("/appdirectory/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/appdirectory/:displayId").post(manager -> new AppDirectoryRequester(manager, notifierProvider()).execute());
		server.route("/appdirectory/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("appdirectory", new AppDirectoryPushRequester());

	}
	private static void initOptionList(AlexandriaUiServer server, PushService pushService) {
		server.route("/optionlist/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/optionlist/:displayId").post(manager -> new OptionListRequester(manager, notifierProvider()).execute());
		server.route("/optionlist/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("optionlist", new OptionListPushRequester());

	}
	private static void initBaseSelector(AlexandriaUiServer server, PushService pushService) {
		server.route("/baseselector/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/baseselector/:displayId").post(manager -> new BaseSelectorRequester(manager, notifierProvider()).execute());
		server.route("/baseselector/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("baseselector", new BaseSelectorPushRequester());

	}
	private static void initSelectorMenu(AlexandriaUiServer server, PushService pushService) {
		server.route("/selectormenu/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/selectormenu/:displayId").post(manager -> new SelectorMenuRequester(manager, notifierProvider()).execute());
		server.route("/selectormenu/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selectormenu", new SelectorMenuPushRequester());

	}
	private static void initSelectorRadioBox(AlexandriaUiServer server, PushService pushService) {
		server.route("/selectorradiobox/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/selectorradiobox/:displayId").post(manager -> new SelectorRadioBoxRequester(manager, notifierProvider()).execute());
		server.route("/selectorradiobox/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selectorradiobox", new SelectorRadioBoxPushRequester());

	}
	private static void initSelectorCheckBox(AlexandriaUiServer server, PushService pushService) {
		server.route("/selectorcheckbox/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/selectorcheckbox/:displayId").post(manager -> new SelectorCheckBoxRequester(manager, notifierProvider()).execute());
		server.route("/selectorcheckbox/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selectorcheckbox", new SelectorCheckBoxPushRequester());

	}
	private static void initSelectorComboBox(AlexandriaUiServer server, PushService pushService) {
		server.route("/selectorcombobox/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/selectorcombobox/:displayId").post(manager -> new SelectorComboBoxRequester(manager, notifierProvider()).execute());
		server.route("/selectorcombobox/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selectorcombobox", new SelectorComboBoxPushRequester());

	}
	private static void initSelectorToggleBox(AlexandriaUiServer server, PushService pushService) {
		server.route("/selectortogglebox/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/selectortogglebox/:displayId").post(manager -> new SelectorToggleBoxRequester(manager, notifierProvider()).execute());
		server.route("/selectortogglebox/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selectortogglebox", new SelectorToggleBoxPushRequester());

	}
	private static void initSelectorListBox(AlexandriaUiServer server, PushService pushService) {
		server.route("/selectorlistbox/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/selectorlistbox/:displayId").post(manager -> new SelectorListBoxRequester(manager, notifierProvider()).execute());
		server.route("/selectorlistbox/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selectorlistbox", new SelectorListBoxPushRequester());

	}
	private static void initSelectorTabs(AlexandriaUiServer server, PushService pushService) {
		server.route("/selectortabs/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/selectortabs/:displayId").post(manager -> new SelectorTabsRequester(manager, notifierProvider()).execute());
		server.route("/selectortabs/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selectortabs", new SelectorTabsPushRequester());

	}
	private static void initSelectorCollectionBox(AlexandriaUiServer server, PushService pushService) {
		server.route("/selectorcollectionbox/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/selectorcollectionbox/:displayId").post(manager -> new SelectorCollectionBoxRequester(manager, notifierProvider()).execute());
		server.route("/selectorcollectionbox/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selectorcollectionbox", new SelectorCollectionBoxPushRequester());

	}
	private static void initMultiple(AlexandriaUiServer server, PushService pushService) {
		server.route("/multiple/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/multiple/:displayId").post(manager -> new MultipleRequester(manager, notifierProvider()).execute());
		server.route("/multiple/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("multiple", new MultiplePushRequester());

	}
	private static void initMultipleImage(AlexandriaUiServer server, PushService pushService) {
		server.route("/multipleimage/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/multipleimage/:displayId").post(manager -> new MultipleImageRequester(manager, notifierProvider()).execute());
		server.route("/multipleimage/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("multipleimage", new MultipleImagePushRequester());

	}
	private static void initSpinner(AlexandriaUiServer server, PushService pushService) {
		server.route("/spinner/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/spinner/:displayId").post(manager -> new SpinnerRequester(manager, notifierProvider()).execute());
		server.route("/spinner/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("spinner", new SpinnerPushRequester());

	}
	private static void initBaseSlider(AlexandriaUiServer server, PushService pushService) {
		server.route("/baseslider/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/baseslider/:displayId").post(manager -> new BaseSliderRequester(manager, notifierProvider()).execute());
		server.route("/baseslider/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("baseslider", new BaseSliderPushRequester());

	}
	private static void initSlider(AlexandriaUiServer server, PushService pushService) {
		server.route("/slider/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/slider/:displayId").post(manager -> new SliderRequester(manager, notifierProvider()).execute());
		server.route("/slider/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("slider", new SliderPushRequester());

	}
	private static void initRangeSlider(AlexandriaUiServer server, PushService pushService) {
		server.route("/rangeslider/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/rangeslider/:displayId").post(manager -> new RangeSliderRequester(manager, notifierProvider()).execute());
		server.route("/rangeslider/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("rangeslider", new RangeSliderPushRequester());

	}
	private static void initTemporalSlider(AlexandriaUiServer server, PushService pushService) {
		server.route("/temporalslider/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/temporalslider/:displayId").post(manager -> new TemporalSliderRequester(manager, notifierProvider()).execute());
		server.route("/temporalslider/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("temporalslider", new TemporalSliderPushRequester());

	}
	private static void initTemplateStamp(AlexandriaUiServer server, PushService pushService) {
		server.route("/templatestamp/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/templatestamp/:displayId").post(manager -> new TemplateStampRequester(manager, notifierProvider()).execute());
		server.route("/templatestamp/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("templatestamp", new TemplateStampPushRequester());

	}
	private static void initTemplateStampEditable(AlexandriaUiServer server, PushService pushService) {
		server.route("/templatestampeditable/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/templatestampeditable/:displayId").post(manager -> new TemplateStampEditableRequester(manager, notifierProvider()).execute());
		server.route("/templatestampeditable/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("templatestampeditable", new TemplateStampEditablePushRequester());

	}
	private static void initExternalTemplateStamp(AlexandriaUiServer server, PushService pushService) {
		server.route("/externaltemplatestamp/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/externaltemplatestamp/:displayId").post(manager -> new ExternalTemplateStampRequester(manager, notifierProvider()).execute());
		server.route("/externaltemplatestamp/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("externaltemplatestamp", new ExternalTemplateStampPushRequester());

	}
	private static void initLibraryTemplateStamp(AlexandriaUiServer server, PushService pushService) {
		server.route("/librarytemplatestamp/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/librarytemplatestamp/:displayId").post(manager -> new LibraryTemplateStampRequester(manager, notifierProvider()).execute());
		server.route("/librarytemplatestamp/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("librarytemplatestamp", new LibraryTemplateStampPushRequester());

	}
	private static void initDisplayStamp(AlexandriaUiServer server, PushService pushService) {
		server.route("/displaystamp/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/displaystamp/:displayId").post(manager -> new DisplayStampRequester(manager, notifierProvider()).execute());
		server.route("/displaystamp/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("displaystamp", new DisplayStampPushRequester());

	}
	private static void initMicroSite(AlexandriaUiServer server, PushService pushService) {
		server.route("/microsite/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/microsite/:displayId").post(manager -> new MicroSiteRequester(manager, notifierProvider()).execute());
		server.route("/microsite/:displayId").get(manager -> new MicroSiteRequester(manager, notifierProvider()).execute());
		server.route("/microsite/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("microsite", new MicroSitePushRequester());

	}
	private static void initHtmlViewer(AlexandriaUiServer server, PushService pushService) {
		server.route("/htmlviewer/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/htmlviewer/:displayId").post(manager -> new HtmlViewerRequester(manager, notifierProvider()).execute());
		server.route("/htmlviewer/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("htmlviewer", new HtmlViewerPushRequester());

	}
	private static void initDocumentEditor(AlexandriaUiServer server, PushService pushService) {
		server.route("/documenteditor/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/documenteditor/:displayId").post(manager -> new DocumentEditorRequester(manager, notifierProvider()).execute());
		server.route("/documenteditor/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("documenteditor", new DocumentEditorPushRequester());

	}
	private static void initDocumentEditorCollabora(AlexandriaUiServer server, PushService pushService) {
		server.route("/documenteditorcollabora/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/documenteditorcollabora/:displayId").post(manager -> new DocumentEditorCollaboraRequester(manager, notifierProvider()).execute());
		server.route("/documenteditorcollabora/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("documenteditorcollabora", new DocumentEditorCollaboraPushRequester());

	}
	private static void initDateNavigator(AlexandriaUiServer server, PushService pushService) {
		server.route("/datenavigator/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/datenavigator/:displayId").post(manager -> new DateNavigatorRequester(manager, notifierProvider()).execute());
		server.route("/datenavigator/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("datenavigator", new DateNavigatorPushRequester());

	}
	private static void initTimeline(AlexandriaUiServer server, PushService pushService) {
		server.route("/timeline/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/timeline/:displayId").post(manager -> new TimelineRequester(manager, notifierProvider()).execute());
		server.route("/timeline/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("timeline", new TimelinePushRequester());

	}
	private static void initEventline(AlexandriaUiServer server, PushService pushService) {
		server.route("/eventline/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/eventline/:displayId").post(manager -> new EventlineRequester(manager, notifierProvider()).execute());
		server.route("/eventline/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("eventline", new EventlinePushRequester());

	}
	private static void initReel(AlexandriaUiServer server, PushService pushService) {
		server.route("/reel/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/reel/:displayId").post(manager -> new ReelRequester(manager, notifierProvider()).execute());
		server.route("/reel/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("reel", new ReelPushRequester());

	}
	private static void initFrame(AlexandriaUiServer server, PushService pushService) {
		server.route("/frame/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/frame/:displayId").post(manager -> new FrameRequester(manager, notifierProvider()).execute());
		server.route("/frame/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("frame", new FramePushRequester());

	}
	private static void initBaseDialog(AlexandriaUiServer server, PushService pushService) {
		server.route("/basedialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/basedialog/:displayId").post(manager -> new BaseDialogRequester(manager, notifierProvider()).execute());
		server.route("/basedialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("basedialog", new BaseDialogPushRequester());

	}
	private static void initDialog(AlexandriaUiServer server, PushService pushService) {
		server.route("/dialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/dialog/:displayId").post(manager -> new DialogRequester(manager, notifierProvider()).execute());
		server.route("/dialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dialog", new DialogPushRequester());

	}
	private static void initAlertDialog(AlexandriaUiServer server, PushService pushService) {
		server.route("/alertdialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/alertdialog/:displayId").post(manager -> new AlertDialogRequester(manager, notifierProvider()).execute());
		server.route("/alertdialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("alertdialog", new AlertDialogPushRequester());

	}
	private static void initDecisionDialog(AlexandriaUiServer server, PushService pushService) {
		server.route("/decisiondialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/decisiondialog/:displayId").post(manager -> new DecisionDialogRequester(manager, notifierProvider()).execute());
		server.route("/decisiondialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("decisiondialog", new DecisionDialogPushRequester());

	}
	private static void initCollectionDialog(AlexandriaUiServer server, PushService pushService) {
		server.route("/collectiondialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/collectiondialog/:displayId").post(manager -> new CollectionDialogRequester(manager, notifierProvider()).execute());
		server.route("/collectiondialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("collectiondialog", new CollectionDialogPushRequester());

	}
	private static void initLayer(AlexandriaUiServer server, PushService pushService) {
		server.route("/layer/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/layer/:displayId").post(manager -> new LayerRequester(manager, notifierProvider()).execute());
		server.route("/layer/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("layer", new LayerPushRequester());

	}
	private static void initDivider(AlexandriaUiServer server, PushService pushService) {
		server.route("/divider/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/divider/:displayId").post(manager -> new DividerRequester(manager, notifierProvider()).execute());
		server.route("/divider/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("divider", new DividerPushRequester());

	}
	private static void initUser(AlexandriaUiServer server, PushService pushService) {
		server.route("/user/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/user/:displayId").post(manager -> new UserRequester(manager, notifierProvider()).execute());
		server.route("/user/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("user", new UserPushRequester());

	}
	private static void initWizard(AlexandriaUiServer server, PushService pushService) {
		server.route("/wizard/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/wizard/:displayId").post(manager -> new WizardRequester(manager, notifierProvider()).execute());
		server.route("/wizard/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("wizard", new WizardPushRequester());

	}
	private static void initWizardNavigator(AlexandriaUiServer server, PushService pushService) {
		server.route("/wizardnavigator/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/wizardnavigator/:displayId").post(manager -> new WizardNavigatorRequester(manager, notifierProvider()).execute());
		server.route("/wizardnavigator/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("wizardnavigator", new WizardNavigatorPushRequester());

	}
	private static void initStep(AlexandriaUiServer server, PushService pushService) {
		server.route("/step/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/step/:displayId").post(manager -> new StepRequester(manager, notifierProvider()).execute());
		server.route("/step/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("step", new StepPushRequester());

	}
	private static void initKpi(AlexandriaUiServer server, PushService pushService) {
		server.route("/kpi/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/kpi/:displayId").post(manager -> new KpiRequester(manager, notifierProvider()).execute());
		server.route("/kpi/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("kpi", new KpiPushRequester());

	}
	private static void initLayerExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/layerexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/layerexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/layerexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("layerexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initHtmlViewerExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/htmlviewerexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/htmlviewerexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/htmlviewerexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("htmlviewerexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initDocumentEditorExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/documenteditorexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/documenteditorexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/documenteditorexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("documenteditorexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTextExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/textexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/textexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/textexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("textexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initHomeTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/hometemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/hometemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/hometemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("hometemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initActionableExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/actionableexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/actionableexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/actionableexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("actionableexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initBaseNumber(AlexandriaUiServer server, PushService pushService) {
		server.route("/basenumber/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/basenumber/:displayId").post(manager -> new BaseNumberRequester(manager, notifierProvider()).execute());
		server.route("/basenumber/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("basenumber", new BaseNumberPushRequester());

	}
	private static void initNumber(AlexandriaUiServer server, PushService pushService) {
		server.route("/number/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/number/:displayId").post(manager -> new NumberRequester(manager, notifierProvider()).execute());
		server.route("/number/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("number", new NumberPushRequester());

	}
	private static void initNumberEditable(AlexandriaUiServer server, PushService pushService) {
		server.route("/numbereditable/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/numbereditable/:displayId").post(manager -> new NumberEditableRequester(manager, notifierProvider()).execute());
		server.route("/numbereditable/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("numbereditable", new NumberEditablePushRequester());

	}
	private static void initBaseDate(AlexandriaUiServer server, PushService pushService) {
		server.route("/basedate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/basedate/:displayId").post(manager -> new BaseDateRequester(manager, notifierProvider()).execute());
		server.route("/basedate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("basedate", new BaseDatePushRequester());

	}
	private static void initDate(AlexandriaUiServer server, PushService pushService) {
		server.route("/date/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/date/:displayId").post(manager -> new DateRequester(manager, notifierProvider()).execute());
		server.route("/date/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("date", new DatePushRequester());

	}
	private static void initDateEditable(AlexandriaUiServer server, PushService pushService) {
		server.route("/dateeditable/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/dateeditable/:displayId").post(manager -> new DateEditableRequester(manager, notifierProvider()).execute());
		server.route("/dateeditable/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dateeditable", new DateEditablePushRequester());

	}
	private static void initBaseText(AlexandriaUiServer server, PushService pushService) {
		server.route("/basetext/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/basetext/:displayId").post(manager -> new BaseTextRequester(manager, notifierProvider()).execute());
		server.route("/basetext/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("basetext", new BaseTextPushRequester());

	}
	private static void initText(AlexandriaUiServer server, PushService pushService) {
		server.route("/text/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/text/:displayId").post(manager -> new TextRequester(manager, notifierProvider()).execute());
		server.route("/text/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("text", new TextPushRequester());

	}
	private static void initTextCode(AlexandriaUiServer server, PushService pushService) {
		server.route("/textcode/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/textcode/:displayId").post(manager -> new TextCodeRequester(manager, notifierProvider()).execute());
		server.route("/textcode/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("textcode", new TextCodePushRequester());

	}
	private static void initTextEditable(AlexandriaUiServer server, PushService pushService) {
		server.route("/texteditable/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/texteditable/:displayId").post(manager -> new TextEditableRequester(manager, notifierProvider()).execute());
		server.route("/texteditable/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("texteditable", new TextEditablePushRequester());

	}
	private static void initTextEditableCode(AlexandriaUiServer server, PushService pushService) {
		server.route("/texteditablecode/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/texteditablecode/:displayId").post(manager -> new TextEditableCodeRequester(manager, notifierProvider()).execute());
		server.route("/texteditablecode/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("texteditablecode", new TextEditableCodePushRequester());

	}
	private static void initBaseFile(AlexandriaUiServer server, PushService pushService) {
		server.route("/basefile/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/basefile/:displayId").post(manager -> new BaseFileRequester(manager, notifierProvider()).execute());
		server.route("/basefile/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("basefile", new BaseFilePushRequester());

	}
	private static void initFile(AlexandriaUiServer server, PushService pushService) {
		server.route("/file/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/file/:displayId").post(manager -> new FileRequester(manager, notifierProvider()).execute());
		server.route("/file/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("file", new FilePushRequester());

	}
	private static void initFileEditable(AlexandriaUiServer server, PushService pushService) {
		server.route("/fileeditable/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/fileeditable/:displayId").post(manager -> new FileEditableRequester(manager, notifierProvider()).execute());
		server.route("/fileeditable/:displayId").get(manager -> new FileEditableRequester(manager, notifierProvider()).execute());
		server.route("/fileeditable/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("fileeditable", new FileEditablePushRequester());

	}
	private static void initBaseImage(AlexandriaUiServer server, PushService pushService) {
		server.route("/baseimage/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/baseimage/:displayId").post(manager -> new BaseImageRequester(manager, notifierProvider()).execute());
		server.route("/baseimage/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("baseimage", new BaseImagePushRequester());

	}
	private static void initImage(AlexandriaUiServer server, PushService pushService) {
		server.route("/image/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/image/:displayId").post(manager -> new ImageRequester(manager, notifierProvider()).execute());
		server.route("/image/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("image", new ImagePushRequester());

	}
	private static void initImageAvatar(AlexandriaUiServer server, PushService pushService) {
		server.route("/imageavatar/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/imageavatar/:displayId").post(manager -> new ImageAvatarRequester(manager, notifierProvider()).execute());
		server.route("/imageavatar/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("imageavatar", new ImageAvatarPushRequester());

	}
	private static void initImageEditable(AlexandriaUiServer server, PushService pushService) {
		server.route("/imageeditable/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/imageeditable/:displayId").post(manager -> new ImageEditableRequester(manager, notifierProvider()).execute());
		server.route("/imageeditable/:displayId").get(manager -> new ImageEditableRequester(manager, notifierProvider()).execute());
		server.route("/imageeditable/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("imageeditable", new ImageEditablePushRequester());

	}
	private static void initBaseLocation(AlexandriaUiServer server, PushService pushService) {
		server.route("/baselocation/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/baselocation/:displayId").post(manager -> new BaseLocationRequester(manager, notifierProvider()).execute());
		server.route("/baselocation/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("baselocation", new BaseLocationPushRequester());

	}
	private static void initLocation(AlexandriaUiServer server, PushService pushService) {
		server.route("/location/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/location/:displayId").post(manager -> new LocationRequester(manager, notifierProvider()).execute());
		server.route("/location/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("location", new LocationPushRequester());

	}
	private static void initLocationEditable(AlexandriaUiServer server, PushService pushService) {
		server.route("/locationeditable/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/locationeditable/:displayId").post(manager -> new LocationEditableRequester(manager, notifierProvider()).execute());
		server.route("/locationeditable/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("locationeditable", new LocationEditablePushRequester());

	}
	private static void initMapExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/mapexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/mapexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/mapexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("mapexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initMicroSiteExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/micrositeexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/micrositeexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/micrositeexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("micrositeexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initWidgetMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/widgetmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/widgetmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/widgetmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("widgetmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initPropertyMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/propertymold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/propertymold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/propertymold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("propertymold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initMethodMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/methodmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/methodmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/methodmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("methodmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initMethodParamMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/methodparammold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/methodparammold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/methodparammold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("methodparammold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initEventsDisplay(AlexandriaUiServer server, PushService pushService) {
		server.route("/eventsdisplay/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/eventsdisplay/:displayId").post(manager -> new EventsDisplayRequester(manager, notifierProvider()).execute());
		server.route("/eventsdisplay/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("eventsdisplay", new EventsDisplayPushRequester());

	}
	private static void initDividerExamplesMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/dividerexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/dividerexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/dividerexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dividerexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initGroupingToolbar1Mold(AlexandriaUiServer server, PushService pushService) {
		server.route("/groupingtoolbar1mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/groupingtoolbar1mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/groupingtoolbar1mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("groupingtoolbar1mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initDownloadSelectionMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/downloadselectionmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/downloadselectionmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/downloadselectionmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("downloadselectionmold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initDynFirstNameItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/dynfirstnameitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/dynfirstnameitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/dynfirstnameitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dynfirstnameitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initDynLastNameItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/dynlastnameitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/dynlastnameitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/dynlastnameitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dynlastnameitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initTable11Mold(AlexandriaUiServer server, PushService pushService) {
		server.route("/table11mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/table11mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/table11mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("table11mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initTable12Mold(AlexandriaUiServer server, PushService pushService) {
		server.route("/table12mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/table12mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/table12mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("table12mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initTable21Mold(AlexandriaUiServer server, PushService pushService) {
		server.route("/table21mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/table21mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/table21mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("table21mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initTable22Mold(AlexandriaUiServer server, PushService pushService) {
		server.route("/table22mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/table22mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/table22mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("table22mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initSorting1Mold(AlexandriaUiServer server, PushService pushService) {
		server.route("/sorting1mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/sorting1mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/sorting1mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("sorting1mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initSorting2Mold(AlexandriaUiServer server, PushService pushService) {
		server.route("/sorting2mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/sorting2mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/sorting2mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("sorting2mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initSelector8ListMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/selector8listmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/selector8listmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/selector8listmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selector8listmold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initGrouping1Mold(AlexandriaUiServer server, PushService pushService) {
		server.route("/grouping1mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/grouping1mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/grouping1mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("grouping1mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initGrouping2Mold(AlexandriaUiServer server, PushService pushService) {
		server.route("/grouping2mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/grouping2mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/grouping2mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("grouping2mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initSearchBox1Mold(AlexandriaUiServer server, PushService pushService) {
		server.route("/searchbox1mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/searchbox1mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/searchbox1mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("searchbox1mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initList1Mold(AlexandriaUiServer server, PushService pushService) {
		server.route("/list1mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/list1mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/list1mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("list1mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initList3Mold(AlexandriaUiServer server, PushService pushService) {
		server.route("/list3mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/list3mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/list3mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("list3mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initList4Mold(AlexandriaUiServer server, PushService pushService) {
		server.route("/list4mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/list4mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/list4mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("list4mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initList5Mold(AlexandriaUiServer server, PushService pushService) {
		server.route("/list5mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/list5mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/list5mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("list5mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initWidgetListMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/widgetlistmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/widgetlistmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/widgetlistmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("widgetlistmold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initDialog4ListMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/dialog4listmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/dialog4listmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/dialog4listmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dialog4listmold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initMap1Mold(AlexandriaUiServer server, PushService pushService) {
		server.route("/map1mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/map1mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/map1mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("map1mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initMap2Mold(AlexandriaUiServer server, PushService pushService) {
		server.route("/map2mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/map2mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/map2mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("map2mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initMap3Mold(AlexandriaUiServer server, PushService pushService) {
		server.route("/map3mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/map3mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/map3mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("map3mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initMap4Mold(AlexandriaUiServer server, PushService pushService) {
		server.route("/map4mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/map4mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/map4mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("map4mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initTable1Row(AlexandriaUiServer server, PushService pushService) {
		server.route("/table1row/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/table1row/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.RowRequester(manager, notifierProvider()).execute());
		server.route("/table1row/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("table1row", new io.intino.alexandria.ui.displays.requesters.RowPushRequester());

	}
	private static void initTable2Row(AlexandriaUiServer server, PushService pushService) {
		server.route("/table2row/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/table2row/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.RowRequester(manager, notifierProvider()).execute());
		server.route("/table2row/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("table2row", new io.intino.alexandria.ui.displays.requesters.RowPushRequester());

	}
	private static void initDynamicTable1Row(AlexandriaUiServer server, PushService pushService) {
		server.route("/dynamictable1row/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/dynamictable1row/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.RowRequester(manager, notifierProvider()).execute());
		server.route("/dynamictable1row/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dynamictable1row", new io.intino.alexandria.ui.displays.requesters.RowPushRequester());

	}
}