/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.services.libraries;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.services.libraries.AlexandriaLibraryArchetype;
import io.intino.alexandria.ui.utils.ZipHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.apache.commons.io.FileUtils;

public class AlexandriaLibraryInstaller {
    private final AlexandriaLibraryArchetype archetype;

    public AlexandriaLibraryInstaller(AlexandriaLibraryArchetype archetype) {
        this.archetype = archetype;
    }

    public void install(File library) {
        if (this.sameLibrary(library) && this.extracted(library)) {
            return;
        }
        this.removeCurrentLibrary();
        this.copy(library);
        this.extract(library);
    }

    private boolean sameLibrary(File library) {
        if (library == null) {
            return true;
        }
        return this.archetype.file().exists() && this.archetype.file().lastModified() == library.lastModified();
    }

    private boolean extracted(File library) {
        if (library == null) {
            return true;
        }
        File extractDirectory = this.archetype.directory();
        if (!extractDirectory.exists()) {
            return false;
        }
        File[] files = extractDirectory.listFiles();
        return files != null && files.length > 0;
    }

    private void removeCurrentLibrary() {
        try {
            if (this.archetype.file().exists()) {
                FileUtils.delete((File)this.archetype.file());
            }
            if (this.archetype.directory().exists()) {
                FileUtils.deleteDirectory((File)this.archetype.directory());
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void copy(File library) {
        try {
            Files.copy(library.toPath(), this.archetype.file().toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void extract(File library) {
        ZipHelper.extract(library, this.archetype.directory());
    }
}

