package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.ActionSwitch;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class ActionSwitchRequester extends ActionableRequester {

	public ActionSwitchRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		ActionSwitch display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("toggle")) {
			display.toggle();
			return;
		}

		super.execute();
	}
}