/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.Json;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.schemas.GridCellInfo;
import io.intino.alexandria.schemas.GridColumn;
import io.intino.alexandria.schemas.GridGroupByInfo;
import io.intino.alexandria.schemas.GridGroupByOptionsInfo;
import io.intino.alexandria.schemas.GridSortInfo;
import io.intino.alexandria.schemas.GridState;
import io.intino.alexandria.ui.displays.components.Grid;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.displays.requesters.PageCollectionRequester;
import io.intino.alexandria.ui.server.AlexandriaUiManager;
import java.util.List;

public class GridRequester
extends PageCollectionRequester {
    public GridRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
    }

    @Override
    public void execute() throws AlexandriaException {
        Grid display = (Grid)this.display();
        if (display == null) {
            return;
        }
        String operation = this.operation();
        if (operation.equals("sort")) {
            display.sort((GridSortInfo)Json.fromString((String)this.manager.fromQuery("v"), GridSortInfo.class));
            return;
        }
        if (operation.equals("updateGroupByOptions")) {
            display.updateGroupByOptions((GridGroupByOptionsInfo)Json.fromString((String)this.manager.fromQuery("v"), GridGroupByOptionsInfo.class));
            return;
        }
        if (operation.equals("groupBy")) {
            display.groupBy((GridGroupByInfo)Json.fromString((String)this.manager.fromQuery("v"), GridGroupByInfo.class));
            return;
        }
        if (operation.equals("cellClick")) {
            display.cellClick((GridCellInfo)Json.fromString((String)this.manager.fromQuery("v"), GridCellInfo.class));
            return;
        }
        if (operation.equals("updateVisibleColumns")) {
            display.updateVisibleColumns(List.of((GridColumn[])Json.fromString((String)this.manager.fromQuery("v"), GridColumn[].class)));
            return;
        }
        if (operation.equals("updateState")) {
            display.updateState((GridState)Json.fromString((String)this.manager.fromQuery("v"), GridState.class));
            return;
        }
        super.execute();
    }
}

