/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.Json;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.schemas.AppDirectoryApplication;
import io.intino.alexandria.schemas.AppDirectoryInfo;
import io.intino.alexandria.ui.displays.components.AbstractAppDirectory;
import io.intino.alexandria.ui.displays.notifiers.AppDirectoryNotifier;
import io.intino.alexandria.ui.utils.IOUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AppDirectory<DN extends AppDirectoryNotifier, B extends Box>
extends AbstractAppDirectory<B> {
    private String icon;
    private List<Application> applicationList = new ArrayList<Application>();
    private String selectedApplication;

    public AppDirectory(B box) {
        super(box);
    }

    public AppDirectory<DN, B> icon(String icon) {
        this._icon(icon);
        this.refresh();
        return this;
    }

    public AppDirectory<DN, B> source(File file, String separator) {
        this._source(file, separator);
        this.refresh();
        return this;
    }

    public AppDirectory<DN, B> source(URL url, String separator) {
        this._source(url, separator);
        this.refresh();
        return this;
    }

    public AppDirectory<DN, B> source(List<Application> applicationList) {
        this._source(applicationList);
        this.refresh();
        return this;
    }

    protected AppDirectory<DN, B> _source(File file, String separator) {
        try {
            this._source(Files.readAllLines(file.toPath(), StandardCharsets.UTF_8), separator);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
        return this;
    }

    protected AppDirectory<DN, B> _source(URL url, String separator) {
        try {
            this._source(IOUtils.readLines(url.openStream(), StandardCharsets.UTF_8), separator);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
        return this;
    }

    public AppDirectory<DN, B> _source(List<String> lines, String separator) {
        this._source(this.applicationsOf(lines, separator));
        return this;
    }

    public AppDirectory<DN, B> selected(String application) {
        this.selectedApplication = application;
        return this;
    }

    protected AppDirectory<DN, B> _source(List<Application> applicationList) {
        this.applicationList = applicationList;
        return this;
    }

    protected Application _add(String name, String url) {
        Application application = new Application(name, url);
        this.applicationList.add(application);
        return application;
    }

    protected AppDirectory<DN, B> _icon(String icon) {
        this.icon = icon;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.refresh();
    }

    @Override
    public void refresh() {
        super.refresh();
        ((AppDirectoryNotifier)this.notifier).refresh(new AppDirectoryInfo().icon(this.icon).applications(this.applications()));
    }

    private List<AppDirectoryApplication> applications() {
        return this.applicationList.stream().map(this::schemaOf).collect(Collectors.toList());
    }

    private AppDirectoryApplication schemaOf(Application application) {
        return new AppDirectoryApplication().name(application.label(this.language())).url(application.url).selected(this.isSelected(application));
    }

    private Boolean isSelected(Application application) {
        return this.selectedApplication != null && this.selectedApplication.equalsIgnoreCase(application.name);
    }

    private List<Application> applicationsOf(List<String> lines, String separator) {
        return lines.stream().map(l -> this.applicationOf((String)l, separator)).sorted(Comparator.comparing(a -> a.label(this.language()))).collect(Collectors.toList());
    }

    private Application applicationOf(String line, String separator) {
        String[] data = line.split(separator);
        Application result = new Application(data[0], data[1]);
        result.translations = data.length > 2 ? (Map)Json.fromString((String)data[2], Map.class) : Collections.emptyMap();
        return result;
    }

    public static class Application {
        public String name;
        public String url;
        public Map<String, String> translations = new HashMap<String, String>();

        public Application(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public String label(String language) {
            return this.translation(language);
        }

        public Application translation(String language, String translation) {
            this.translations.put(language, translation);
            return this;
        }

        protected String translation(String language) {
            return this.translations.getOrDefault(language, this.name);
        }
    }
}

