/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.server;

import io.intino.alexandria.http.pushservice.Client;
import io.intino.alexandria.http.pushservice.PushService;
import io.intino.alexandria.http.server.AlexandriaHttpManager;
import io.intino.alexandria.http.server.AlexandriaHttpRequest;
import io.intino.alexandria.http.server.AlexandriaHttpResourceProvider;
import io.intino.alexandria.http.server.AlexandriaHttpResponse;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UISession;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import java.util.Map;

public class AlexandriaUiManager
extends AlexandriaHttpManager<io.intino.alexandria.ui.services.push.PushService> {
    private final AuthService authService;
    private final boolean hasUserHome;
    public static final String KonosUserHomePath = "/konos/user";

    public AlexandriaUiManager(io.intino.alexandria.ui.services.push.PushService pushService, AlexandriaHttpRequest request, AlexandriaHttpResponse response, AlexandriaHttpResourceProvider resourceProvider, AuthService authService, boolean hasUserHome) {
        super((PushService)pushService, request, response, resourceProvider);
        this.authService = authService;
        this.hasUserHome = hasUserHome;
    }

    public AuthService authService() {
        return this.authService;
    }

    public void linkToThread(UIClient<?> client) {
        ((io.intino.alexandria.ui.services.push.PushService)this.pushService).linkToThread(client);
    }

    public void unlinkFromThread() {
        ((io.intino.alexandria.ui.services.push.PushService)this.pushService).unlinkFromThread();
    }

    public void unRegister(UIClient<?> client) {
        ((io.intino.alexandria.ui.services.push.PushService)this.pushService).unRegister((Client)client);
    }

    public String userHomePath() {
        return this.hasUserHome ? KonosUserHomePath : "";
    }

    public String requestUrl() {
        String requestUri;
        Object result = this.baseUrl();
        if (!((String)result).endsWith("/")) {
            result = (String)result + "/";
        }
        result = (String)result + ((requestUri = this.request().raw().getRequestURI()) != null && requestUri.startsWith("/") ? requestUri.substring(1) : requestUri);
        return this.withQueryString((String)result);
    }

    private String withQueryString(String result) {
        String queryString = this.request().raw().getQueryString();
        if (queryString == null || queryString.isEmpty()) {
            return result;
        }
        return result + "?" + queryString;
    }

    public UISession currentSession() {
        return (UISession)super.currentSession();
    }

    public UISession session(String id) {
        return (UISession)((io.intino.alexandria.ui.services.push.PushService)this.pushService()).session(id);
    }

    public UIClient<?> client(String id) {
        return (UIClient)((io.intino.alexandria.ui.services.push.PushService)this.pushService()).client(id);
    }

    public UIClient<?> currentClient() {
        return (UIClient)((io.intino.alexandria.ui.services.push.PushService)this.pushService()).currentClient();
    }

    public String languageFromHeader() {
        String languageMetadata = this.request().header("Accept-Language");
        if (languageMetadata == null) {
            return null;
        }
        return this.languageOf(languageMetadata.split(",")[0]);
    }

    public String ipAddressFromHeader() {
        HttpServletRequest raw = this.request().raw();
        String ipAddress = raw.getHeader("Remote_Addr");
        if (ipAddress == null || ipAddress.isEmpty()) {
            ipAddress = raw.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ipAddress != null && !ipAddress.isEmpty()) {
            return ipAddress;
        }
        return raw.getRemoteAddr();
    }

    public String languageFromUrl() {
        return this.languageOf(this.request().queryParam("language"));
    }

    public void redirect(String location) {
        this.currentSession().browser().add("callback", this.requestUrl());
        super.redirect(location);
    }

    private String languageOf(String language) {
        if (language == null || language.isEmpty()) {
            return null;
        }
        Locale locale = Locale.forLanguageTag(language);
        return (locale.getCountry().isEmpty() ? locale.getLanguage() : locale.getCountry()).toLowerCase();
    }

    public Map<String, String> cookies() {
        return this.request().cookies();
    }
}

