/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.resources;

import io.intino.alexandria.UiFrameworkBox;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.pages.ExampleContentPage;
import io.intino.alexandria.ui.server.AlexandriaUiManager;
import io.intino.alexandria.ui.server.resources.Resource;
import java.util.UUID;
import java.util.function.Function;

public class ExampleContentResource
extends Resource {
    private final UiFrameworkBox box;

    public ExampleContentResource(UiFrameworkBox box, AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
        this.box = box;
    }

    @Override
    public void execute() throws AlexandriaException {
        super.execute();
        this.fillDeviceParameter();
        this.render();
    }

    private void render() {
        String clientId = UUID.randomUUID().toString();
        final ExampleContentPage page = new ExampleContentPage();
        page.session = this.manager.currentSession();
        page.session.browser().onRedirect(location -> this.manager.redirect((String)location));
        page.session.browser().requestUrl(this.manager.requestUrl());
        page.session.whenLogin(new Function<String, String>(){

            @Override
            public String apply(String baseUrl) {
                return ExampleContentResource.this.authenticate(page.session, baseUrl);
            }
        });
        page.session.whenLogout(b -> this.logout(page.session));
        page.box = this.box;
        page.clientId = clientId;
        page.webDirectories = this.manager.webDirectories();
        page.googleApiKey = "AIzaSyA8FjeAX36umrYD8Jk2FbRFWqDEulInKIA";
        page.device = this.parameterValue("device");
        page.token = this.parameterValue("token");
        if (!page.hasPermissions()) {
            this.manager.redirect(page.redirectUrl());
            return;
        }
        this.manager.write(page.execute());
    }
}

