/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.documentation.model.data;

import io.intino.alexandria.schemas.Property;
import io.intino.alexandria.ui.documentation.Model;
import io.intino.alexandria.ui.documentation.model.BaseWidget;
import java.util.Arrays;
import java.util.Collections;

public class TextWidget
extends BaseWidget {
    public TextWidget() {
        super("Use this widget to present text content in your user interface");
        this.facets(Arrays.asList("Multiple", "Code", "Editable", "Highlighted"));
    }

    @Override
    protected void addProperties() {
        super.addProperties();
        this.add(Model.property("mode", Property.Type.Word, "Transforms text value by applying desired mode", "Uppercase", "Lowercase", "Capitalize", "Normal"));
        this.add(Model.property("value", Property.Type.Text, "The initial text to display in the box, if any", new String[0]));
        this.add(Model.property("language", Property.Type.Word, "Language of code defined in widget.", this.languages()).facets(Collections.singletonList("Code")));
        this.add(Model.property("prefix", Property.Type.Text, "Text to add before the value.", new String[0]));
        this.add(Model.property("suffix", Property.Type.Text, "Text to add after the value.", new String[0]));
        this.add(Model.property("textColor", Property.Type.Text, "Color for text.", new String[0]).facets(Collections.singletonList("Highlight")));
        this.add(Model.property("backgroundColor", Property.Type.Text, "Color for background.", new String[0]).facets(Collections.singletonList("Highlight")));
        this.add(Model.property("noItemsMessage", Property.Type.Text, "Text rendered when no elements are added to component.", new String[0]).facets(Collections.singletonList("Multiple")));
        this.add(Model.property("arrangement", Property.Type.Word, "Text rendered when no elements are added to component.", this.multipleArrangements()).facets(Collections.singletonList("Multiple")));
        this.add(Model.property("spacing", Property.Type.Word, "Spacing between text components applied.", this.multipleSpacings()).facets(Collections.singletonList("Multiple")));
    }

    @Override
    protected void addMethods() {
        super.addMethods();
        this.addMethod(Model.method("value", Collections.emptyList(), "Returns value stored in widget", "String"));
        this.addMethod(Model.method("value", Collections.singletonList(Model.methodParameter("value", "String")), "Allows updating text value", "TextEditable").facets(Collections.singletonList("Editable")));
        this.addMethod(Model.method("readonly", Collections.emptyList(), "Returns true if component is readonly", "Bool").facets(Collections.singletonList("Editable")));
        this.addMethod(Model.method("readonly", Collections.singletonList(Model.methodParameter("value", "Bool")), "Allows updating readonly state. If true component is disabled for edition", "TextEditable").facets(Collections.singletonList("Editable")));
    }

    @Override
    protected void addEvents() {
        super.addEvents();
        this.addEvent(Model.method("onChange", Collections.singletonList(Model.methodParameter("listener", "io.intino.alexandria.ui.displays.events.ChangeListener")), "This event is fired when widget value changes", "TextEditable").facets(Collections.singletonList("Editable")));
        this.addEvent(Model.method("onKeyPress", Collections.singletonList(Model.methodParameter("listener", "io.intino.alexandria.ui.displays.events.KeyPressListener")), "This event is fired when widget user press any key", "TextEditable").facets(Collections.singletonList("Editable")));
        this.addEvent(Model.method("onEnterPress", Collections.singletonList(Model.methodParameter("listener", "io.intino.alexandria.ui.displays.events.KeyPressListener")), "This event is fired when user press 'Enter' key", "TextEditable").facets(Collections.singletonList("Editable")));
    }

    private String[] languages() {
        return new String[]{"Html", "Java", "Javascript", "R"};
    }
}

