package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.SignAction;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UIMessage;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class SignActionPushRequester extends io.intino.alexandria.ui.displays.requesters.ComponentPushRequester {

	public void execute(UIClient client, UIMessage message) {
		SignAction display = display(client, message);
		if (display == null) return;
		String operation = operation(message);
		String data = data(message);

		if (operation.equals("signing")) {
			display.signing();
			return;
		}
		else if (operation.equals("success")) {
			display.success(io.intino.alexandria.Json.fromString(data, io.intino.alexandria.schemas.SignActionSignatureSuccess.class));
			return;
		}
		else if (operation.equals("failure")) {
			display.failure(io.intino.alexandria.Json.fromString(data, io.intino.alexandria.schemas.SignActionSignatureFailure.class));
			return;
		}

		super.execute(client, message);
	}

}