package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.DateEditable;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class DateEditableRequester extends BaseDateRequester {

	public DateEditableRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		DateEditable display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("notifyChange")) {
			display.notifyChange(manager.fromQuery("v") != null ? java.time.Instant.ofEpochMilli(Long.parseLong(manager.fromQuery("v"))) : null);
			return;
		}

		super.execute();
	}
}