package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.DateEditable;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UIMessage;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class DateEditablePushRequester extends io.intino.alexandria.ui.displays.requesters.ComponentPushRequester {

	public void execute(UIClient client, UIMessage message) {
		DateEditable display = display(client, message);
		if (display == null) return;
		String operation = operation(message);
		String data = data(message);

		if (operation.equals("notifyChange")) {
			display.notifyChange(data != null ? java.time.Instant.ofEpochMilli(Long.parseLong(data)) : null);
			return;
		}

		super.execute(client, message);
	}

}