package io.intino.alexandria.ui.displays;

import io.intino.alexandria.ui.Soul;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractRouteDispatcher implements io.intino.alexandria.ui.displays.DisplayRouteDispatcher {
	private static java.util.Map<String, String> patterns = new HashMap<>();

	public AbstractRouteDispatcher() {
		registerPatterns();
	}

	@Override
	public void dispatch(Soul soul, String address) {
		address = address.replaceFirst(soul.session().browser().basePath(), "");
		List<String> params = paramsOf(address);
		address = addressWithoutQueryString(address);
		if (address.length() <= 1) { dispatchHome(soul); return; }
		if (address.matches(patterns.get("home"))) { dispatchHome(soul); return; }
		if (address.matches(patterns.get("widgets"))) { dispatchWidgets(soul); return; }
		if (address.matches(patterns.get("widgetType"))) { dispatchWidgetType(soul, params.get(0)); return; }
		if (address.matches(patterns.get("microSite"))) { dispatchMicroSite(soul, params.get(0)); return; }
		if (address.length() <= 1) { dispatchMobileHome(soul); return; }
		if (address.matches(patterns.get("mobileHome"))) { dispatchMobileHome(soul); return; }
	}

	public abstract void dispatchHome(Soul soul);
	public abstract void dispatchWidgets(Soul soul);
	public abstract void dispatchWidgetType(Soul soul, String type);
	public abstract void dispatchMicroSite(Soul soul, String page);
	public abstract void dispatchMobileHome(Soul soul);

	private void registerPatterns() {
		if (patterns.size() > 0) return;
		patterns.put("home", "");
		patterns.put("widgets", "\\/widgets");
		patterns.put("widgetType", "\\/widgets\\/([^\\/]*)");
		patterns.put("microSite", "\\/widgets\\/microsite\\/([^\\/]*)");
		patterns.put("mobileHome", "\\/mobile");
	}

	private String patternOf(String address) {
		String addressPart = addressWithoutQueryString(address);
		if (addressPart.equals("/") || addressPart.matches(patterns.get("home"))) return patterns.get("home");
		else if (addressPart.matches(patterns.get("home"))) return patterns.get("home");
		else if (addressPart.matches(patterns.get("widgets"))) return patterns.get("widgets");
		else if (addressPart.matches(patterns.get("widgetType"))) return patterns.get("widgetType");
		else if (addressPart.matches(patterns.get("microSite"))) return patterns.get("microSite");
		if (addressPart.equals("/") || addressPart.matches(patterns.get("mobileHome"))) return patterns.get("mobileHome");
		else if (addressPart.matches(patterns.get("mobileHome"))) return patterns.get("mobileHome");
		return null;
	}

	private List<String> paramsOf(String address) {
		return paramsOf(address, patternOf(address));
	}

	private List<String> paramsOf(String address, String pattern) {
		if (pattern == null) return java.util.Collections.emptyList();
		Pattern p = Pattern.compile(pattern);
		Matcher m = p.matcher(address);
		if (!m.find()) return Collections.emptyList();
		List<String> result = new ArrayList<>();
		for (int i=1; i<=m.groupCount(); i++) result.add(m.group(i).split("\\?")[0]);
		return addQueryStringParams(address, result);
	}

	private List<String> addQueryStringParams(String address, List<String> result) {
        if (address.indexOf("?") == -1) return result;
        String[] parameters = address.split("\\?")[1].split("&");
        for (int i = 0; i < parameters.length; i++) {
            String[] split = parameters[i].split("=");
            result.add(split.length > 1 ? split[1] : "");
        }
        return result;
	}

    private String addressWithoutQueryString(String address) {
        return address.indexOf("?") != -1 ? address.substring(0, address.indexOf("?")) : address;
    }

}