package io.intino.alexandria.ui;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.DisplayRouteManager;
import io.intino.alexandria.ui.services.TranslatorService;
import io.intino.alexandria.ui.services.push.PushService;

public abstract class AlexandriaUiBox extends Box {
	private DisplayRouteManager router;
	protected TranslatorService translatorService;
	protected PushService pushService;

	public DisplayRouteManager routeManager() {
		return this.router;
	}

	public void routeManager(DisplayRouteManager router) {
		this.router = router;
	}

	public abstract void registerSoul(String clientId, Soul soul);
	public abstract void unRegisterSoul(String id);

	public TranslatorService translatorService() {
		return translatorService;
	}

	public PushService pushService() {
		return pushService;
	}

	protected AlexandriaUiBox pushService(PushService pushService) {
		this.pushService = pushService;
		return this;
	}

	public interface SoulsClosed {
		void accept();
	}
}
