/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.model.chat.buckets;

import io.intino.alexandria.Json;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.model.chat.Message;
import io.intino.alexandria.ui.model.chat.MessageReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class BucketMessageReader
implements MessageReader {
    private final List<File> sources;
    private List<String> sourceLines;
    private int sourceIndex;
    private int contentIndex;

    public BucketMessageReader(File root) {
        this.sources = this.loadSources(root);
        this.sourceLines = Collections.emptyList();
        this.sourceIndex = this.sources.size();
        this.contentIndex = -1;
    }

    @Override
    public Iterator<Message> iterator() {
        return new Iterator<Message>(){

            @Override
            public boolean hasNext() {
                return BucketMessageReader.this.sourceIndex > 0 && !BucketMessageReader.this.sources.isEmpty() || BucketMessageReader.this.contentIndex > 0;
            }

            @Override
            public Message next() {
                if (!this.hasNext()) {
                    return null;
                }
                while (BucketMessageReader.this.contentIndex <= 0 && BucketMessageReader.this.sourceIndex > 0) {
                    BucketMessageReader.this.nextSource();
                }
                --BucketMessageReader.this.contentIndex;
                return BucketMessageReader.this.contentIndex >= 0 ? BucketMessageReader.this.messageFrom(BucketMessageReader.this.sourceLines.get(BucketMessageReader.this.contentIndex)) : null;
            }
        };
    }

    private void nextSource() {
        --this.sourceIndex;
        this.sourceLines = this.readSourceLines();
        this.contentIndex = this.sourceLines.size();
    }

    private List<String> readSourceLines() {
        try {
            return Files.readAllLines(this.sources.get(this.sourceIndex).toPath());
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<File> loadSources(File root) {
        File[] files = root.listFiles();
        return files != null ? Arrays.stream(files).filter(f -> !f.isDirectory()).sorted((o1, o2) -> Timetag.of((String)o2.getName()).compare(Timetag.of((String)o1.getName()))).collect(Collectors.toList()) : Collections.emptyList();
    }

    private Message messageFrom(String line) {
        return (Message)Json.fromJson((String)line, Message.class);
    }
}

