/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.templates;

import io.intino.alexandria.Resource;
import io.intino.alexandria.UiFrameworkBox;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.File;
import io.intino.alexandria.ui.displays.components.ImageEditable;
import io.intino.alexandria.ui.displays.templates.AbstractMultipleExamplesMold;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class MultipleExamplesMold
extends AbstractMultipleExamplesMold<UiFrameworkBox> {
    public MultipleExamplesMold(UiFrameworkBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        this.multiple1.addAll(List.of("Value 1", "Value 2", "Value 3"));
        this.multiple2.add("Value 1", "lorem ipsum dolor sit amet");
        this.multiple2.add("Value 2");
        this.multiple2.add("Value 3");
        this.files().forEach(f -> this.multiple3.add(f));
        this.multiple3.onChange(event -> {
            ImageEditable display = (ImageEditable)event.component();
            display.value(this.save((Resource)event.item()));
        });
        this.multiple3.onRemove(event -> this.javaFiles().get(event.index()).delete());
    }

    private List<java.io.File> javaFiles() {
        java.io.File[] files = new java.io.File("/tmp/multiple3").listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).collect(Collectors.toList());
    }

    private List<File> files() {
        return this.javaFiles().stream().map(f -> {
            try {
                return new File().filename(f.getName()).value(f.toPath().toUri().toURL());
            }
            catch (MalformedURLException e) {
                Logger.error((Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private URL save(Resource resource) {
        try {
            new java.io.File("/tmp/multiple3/").mkdirs();
            Path result = Path.of("/tmp/multiple3/" + resource.name(), new String[0]);
            Files.write(result, resource.bytes(), new OpenOption[0]);
            return result.toUri().toURL();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }
}

