/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components.collection.loaders;

import io.intino.alexandria.ui.displays.components.collection.loaders.ItemLoader;
import io.intino.alexandria.ui.model.datasource.DynamicTableDatasource;
import io.intino.alexandria.ui.model.datasource.temporal.TemporalDynamicTableDatasource;
import io.intino.alexandria.ui.model.dynamictable.Section;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DynamicTableItemLoader<Item>
extends ItemLoader<DynamicTableDatasource<Item>, Item> {
    private int pageSize;
    private String dimension;
    private String drill;
    private Section section;
    private String row;

    public DynamicTableItemLoader(DynamicTableDatasource<Item> source, int pageSize) {
        super(source);
        this.pageSize = pageSize;
    }

    public String dimension() {
        return this.dimension;
    }

    public DynamicTableItemLoader dimension(String dimension) {
        this.dimension = dimension;
        return this;
    }

    public String drill() {
        return this.drill;
    }

    public DynamicTableItemLoader drill(String drill) {
        this.drill = drill;
        return this;
    }

    public DynamicTableItemLoader section(Section section) {
        this.section = section;
        return this;
    }

    public DynamicTableItemLoader row(String row) {
        this.row = row;
        return this;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public DynamicTableItemLoader pageSize(int size) {
        this.pageSize = size;
        return this;
    }

    public List<Section> sections() {
        if (this.source instanceof TemporalDynamicTableDatasource) {
            return this.timetag != null ? ((TemporalDynamicTableDatasource)this.source).sections(this.timetag, this.dimension, this.drill, this.condition, this.filters) : Collections.emptyList();
        }
        return ((DynamicTableDatasource)this.source).sections(this.dimension, this.drill, this.condition, this.filters);
    }

    public synchronized List<Item> page(int page) {
        page = this.checkPageRange(page);
        return this.items(this.start(page), this.pageSize);
    }

    public int pageCount() {
        if (this.pageSize <= 0) {
            return 0;
        }
        return this.pageOf(this.itemCount());
    }

    public int start(int page) {
        return page * this.pageSize;
    }

    public int pageOf(long index) {
        return (int)(Math.floor(index / (long)this.pageSize) + (double)(index % (long)this.pageSize > 0L ? 1 : 0));
    }

    public List<Item> moreItems(int start, int stop) {
        return this.items(start, stop - start + 1);
    }

    @Override
    protected long calculateItemCount(String condition) {
        if (this.section == null || this.row == null) {
            return 0L;
        }
        if (this.source instanceof TemporalDynamicTableDatasource) {
            return this.timetag != null ? ((TemporalDynamicTableDatasource)this.source).itemCount(this.timetag, this.section, this.row, condition, this.filters) : 0L;
        }
        if (this.source instanceof DynamicTableDatasource) {
            return ((DynamicTableDatasource)this.source).itemCount(this.section, this.row, condition, this.filters);
        }
        return 0L;
    }

    @Override
    public List<Item> items(String ... sortings) {
        int itemCount = Long.valueOf(this.itemCount()).intValue();
        List<String> sortingList = Arrays.asList(sortings);
        if (this.source instanceof TemporalDynamicTableDatasource) {
            return this.timetag != null ? ((TemporalDynamicTableDatasource)this.source).items(this.timetag, 0, itemCount, this.section, this.row, this.condition, this.filters, sortingList) : Collections.emptyList();
        }
        if (this.source instanceof DynamicTableDatasource) {
            return ((DynamicTableDatasource)this.source).items(0, itemCount, this.section, this.row, this.condition, this.filters, sortingList);
        }
        return Collections.emptyList();
    }

    private int checkPageRange(int page) {
        int countPages;
        if (page <= 0) {
            page = 0;
        }
        if (page >= (countPages = this.pageCount()) && countPages > 0) {
            page = countPages - 1;
        }
        return page;
    }

    private List<Item> items(int start, int pageSize) {
        ArrayList<String> sortings = new ArrayList<String>(this.sortings);
        if (this.source instanceof TemporalDynamicTableDatasource) {
            return this.timetag != null ? ((TemporalDynamicTableDatasource)this.source).items(this.timetag, start, pageSize, this.section, this.row, this.condition, this.filters, sortings) : Collections.emptyList();
        }
        return ((DynamicTableDatasource)this.source).items(start, pageSize, this.section, this.row, this.condition, this.filters, sortings);
    }
}

