package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.Wizard;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class WizardRequester extends io.intino.alexandria.ui.displays.requesters.ComponentRequester {

	public WizardRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		Wizard display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("back")) {
			display.back();
			return;
		}
		else if (operation.equals("next")) {
			display.next();
			return;
		}
		else if (operation.equals("finishConfirmed")) {
			display.finishConfirmed();
			return;
		}
		else if (operation.equals("finish")) {
			display.finish();
			return;
		}

		super.execute();
	}
}