package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.WizardNavigator;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class WizardNavigatorRequester extends io.intino.alexandria.ui.displays.requesters.ComponentRequester {

	public WizardNavigatorRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		WizardNavigator display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("back")) {
			display.back();
			return;
		}
		else if (operation.equals("select")) {
			display.select(Integer.parseInt(manager.fromQuery("v")));
			return;
		}
		else if (operation.equals("next")) {
			display.next();
			return;
		}
		else if (operation.equals("finish")) {
			display.finish();
			return;
		}

		super.execute();
	}
}