package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.GroupingToolbar;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class GroupingToolbarRequester extends io.intino.alexandria.ui.displays.requesters.ComponentRequester {

	public GroupingToolbarRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		GroupingToolbar display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("apply")) {
			display.apply();
			return;
		}
		else if (operation.equals("reset")) {
			display.reset();
			return;
		}
		else if (operation.equals("removeFilter")) {
			display.removeFilter(manager.fromQuery("v"));
			return;
		}

		super.execute();
	}
}