package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.DashboardShiny;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UIMessage;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class DashboardShinyPushRequester extends io.intino.alexandria.ui.displays.requesters.ComponentPushRequester {

	public void execute(UIClient client, UIMessage message) {
		DashboardShiny display = display(client, message);
		if (display == null) return;
		String operation = operation(message);
		String data = data(message);

		if (operation.equals("showSettings")) {
			display.showSettings();
			return;
		}
		else if (operation.equals("hideSettings")) {
			display.hideSettings();
			return;
		}
		else if (operation.equals("saveServerScript")) {
			display.saveServerScript(data);
			return;
		}
		else if (operation.equals("saveUiScript")) {
			display.saveUiScript(data);
			return;
		}

		super.execute(client, message);
	}

}