/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.model.timeline;

import io.intino.alexandria.Scale;
import io.intino.alexandria.ui.model.timeline.MagnitudeDefinition;
import java.time.Instant;
import java.util.List;
import java.util.Map;

public interface TimelineDatasource {
    public String name();

    public List<MagnitudeDefinition> magnitudes();

    public Magnitude magnitude(MagnitudeDefinition var1);

    public List<Scale> scales();

    public Instant from(Scale var1);

    public Instant to(Scale var1);

    default public MagnitudeDefinition magnitudeDefinition(String name) {
        return this.magnitudes().stream().filter(d -> d.name().equals(name)).findFirst().orElse(null);
    }

    default public Magnitude magnitude(String magnitudeName) {
        MagnitudeDefinition magnitude = this.magnitudeDefinition(magnitudeName);
        return magnitude != null ? this.magnitude(magnitude) : null;
    }

    public static interface Magnitude {
        public MagnitudeDefinition definition();

        public Status status();

        public double value();

        public Double min();

        public Double max();

        public Double percentage();

        public Summary summary(Instant var1, Scale var2);

        public Serie serie(Scale var1, Instant var2, int var3);

        public Serie serie(Scale var1, Instant var2, Instant var3);

        public String customHtmlView(Scale var1);

        public static enum Status {
            Normal,
            Warning,
            Error;

        }
    }

    public static class Annotation {
        private final String label;
        private final String color;
        private final Symbol symbol;

        public Annotation(String label) {
            this(label, "#ed6c02", Symbol.Circle);
        }

        public Annotation(String label, String color) {
            this(label, color, Symbol.Circle);
        }

        private Annotation(String label, String color, Symbol symbol) {
            this.label = label;
            this.color = color;
            this.symbol = symbol;
        }

        public String label() {
            return this.label;
        }

        public String color() {
            return this.color;
        }

        public Symbol symbol() {
            return this.symbol;
        }

        public static enum Symbol {
            Circle,
            Square,
            Diamond,
            Triangle;

        }
    }

    public static interface Serie {
        public String name();

        public Map<Instant, Double> values();

        public Map<Instant, List<Annotation>> annotations();
    }

    public static interface Summary {
        public double average();

        public Instant averageDate();

        public double max();

        public Instant maxDate();

        public double min();

        public Instant minDate();

        public List<Attribute> attributes();

        public static interface Attribute {
            public String name();

            public double value();

            public Instant date();
        }
    }
}

