/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.TimelineAnnotation;
import io.intino.alexandria.schemas.TimelineHistory;
import io.intino.alexandria.schemas.TimelineHistoryEntry;
import io.intino.alexandria.schemas.TimelineHistoryFetch;
import io.intino.alexandria.schemas.TimelineMagnitude;
import io.intino.alexandria.schemas.TimelineMagnitudeSorting;
import io.intino.alexandria.schemas.TimelineMagnitudeVisibility;
import io.intino.alexandria.schemas.TimelineSerie;
import io.intino.alexandria.schemas.TimelineSetup;
import io.intino.alexandria.schemas.TimelineSummary;
import io.intino.alexandria.schemas.TimelineSummaryAttribute;
import io.intino.alexandria.schemas.TimelineSummaryValue;
import io.intino.alexandria.ui.displays.components.AbstractTimeline;
import io.intino.alexandria.ui.displays.events.SelectEvent;
import io.intino.alexandria.ui.displays.events.SelectListener;
import io.intino.alexandria.ui.displays.notifiers.TimelineNotifier;
import io.intino.alexandria.ui.model.ScaleFormatter;
import io.intino.alexandria.ui.model.timeline.Formatter;
import io.intino.alexandria.ui.model.timeline.MagnitudeDefinition;
import io.intino.alexandria.ui.model.timeline.TimelineDatasource;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Timeline<DN extends TimelineNotifier, B extends Box>
extends AbstractTimeline<B> {
    private TimelineDatasource source;
    private Mode mode;
    private String stateLabel;
    private String historyLabel;
    private List<TimelineMagnitudeVisibility> magnitudesVisibility;
    private List<TimelineMagnitudeSorting> magnitudesSorting;
    private int summaryPointsCount = 24;
    private final Map<Scale, Instant> selectedInstants = new HashMap<Scale, Instant>();
    private Scale selectedScale = null;
    private SelectListener selectListener;
    private SelectListener selectScaleListener;
    private boolean historyWithRelativeValues = true;
    private static final int DefaultSummaryPointsCount = 24;
    private static final Set<String> EnglishNotationLanguages = Set.of("mx", "en");

    public Timeline(B box) {
        super(box);
    }

    public <DS extends TimelineDatasource> Timeline<DN, B> stateLabel(String label) {
        this.stateLabel = label;
        return this;
    }

    public <DS extends TimelineDatasource> Timeline<DN, B> historyLabel(String label) {
        this.historyLabel = label;
        return this;
    }

    public <DS extends TimelineDatasource> Timeline<DN, B> source(DS source) {
        this.source = source;
        return this;
    }

    public Mode mode() {
        return this.mode;
    }

    protected Timeline<DN, B> _mode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public Timeline<DN, B> onSelect(SelectListener listener) {
        this.selectListener = listener;
        return this;
    }

    public Timeline<DN, B> onSelectScale(SelectListener listener) {
        this.selectScaleListener = listener;
        return this;
    }

    public Timeline<DN, B> select(Instant instant) {
        if (this.source == null) {
            return this;
        }
        if (this.selectedInstant(this.selectedScale()) != null && this.selectedInstant(this.selectedScale()).equals(instant)) {
            return this;
        }
        this.selectInstant(this.selectedScale(), instant);
        return this;
    }

    public List<TimelineMagnitudeVisibility> magnitudesVisibility() {
        return this.magnitudesVisibility;
    }

    public Timeline<DN, B> magnitudesVisibility(List<TimelineMagnitudeVisibility> magnitudesVisibility) {
        this.magnitudesVisibility = magnitudesVisibility;
        ((TimelineNotifier)this.notifier).refreshMagnitudesVisibility(magnitudesVisibility);
        return this;
    }

    public List<TimelineMagnitudeSorting> magnitudesSorting() {
        return this.magnitudesSorting;
    }

    public Timeline<DN, B> magnitudesSorting(List<TimelineMagnitudeSorting> magnitudesSorting) {
        this.magnitudesSorting = magnitudesSorting;
        ((TimelineNotifier)this.notifier).refreshMagnitudesSorting(magnitudesSorting);
        return this;
    }

    public Timeline<DN, B> summaryPointsCount(int count) {
        this.summaryPointsCount = count;
        return this;
    }

    public void select(Scale scale) {
        this.changeScale(scale);
    }

    public void changeScale(String scale) {
        this.changeScale(Scale.valueOf((String)scale));
    }

    public void changeScale(Scale scale) {
        if (this.selectedScale == scale) {
            return;
        }
        this.selectedScale = scale;
        this.refreshMagnitudes();
        if (this.selectScaleListener != null) {
            this.selectScaleListener.accept(new SelectEvent(this, this.selectedScale));
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.source == null) {
            throw new RuntimeException("Timeline source not defined");
        }
        ((TimelineNotifier)this.notifier).setup(new TimelineSetup().mode(this.mode.name()).name(this.source.name()).stateLabel(this.stateLabel).historyLabel(this.historyLabel).scales(this.source.scales().stream().map(Enum::name).collect(Collectors.toList())).magnitudes(this.source.magnitudes().stream().map(this::schemaOf).collect(Collectors.toList())));
    }

    public void historyWithRelativeValues(Boolean value) {
        Scale scale = this.selectedScale();
        this.historyWithRelativeValues = value;
        ((TimelineNotifier)this.notifier).showHistoryDialog(new TimelineHistory().from(this.source.from(scale)).to(this.source.to(scale)).hasRelativeValues(true));
    }

    public void openHistory(String magnitudeName) {
        Scale scale = this.selectedScale();
        TimelineDatasource.Magnitude magnitude = this.source.magnitude(magnitudeName);
        boolean hasRelativeValues = magnitude.definition().unit() != null && !magnitude.definition().unit().equals("%") && magnitude.max() != null;
        this.historyWithRelativeValues = true;
        ((TimelineNotifier)this.notifier).showHistoryDialog(new TimelineHistory().from(this.source.from(scale)).to(this.source.to(scale)).hasRelativeValues(hasRelativeValues));
    }

    public void fetch(TimelineHistoryFetch fetch) {
        TimelineDatasource.Magnitude magnitude = this.source.magnitude(fetch.magnitude());
        Scale scale = this.selectedScale();
        TimelineDatasource.Serie serie = magnitude.serie(scale, fetch.start(), fetch.end());
        Map<Instant, Double> values = serie.values();
        Map<Instant, List<TimelineDatasource.Annotation>> annotations = serie.annotations();
        Formatter formatter = magnitude.definition().formatter();
        ((TimelineNotifier)this.notifier).refreshHistory(this.fillWithZeros(values, fetch.end(), scale).entrySet().stream().map(e -> this.historyEntryOf(magnitude, (Map.Entry<Instant, Double>)e, formatter, annotations)).collect(Collectors.toList()));
    }

    private TimelineHistoryEntry historyEntryOf(TimelineDatasource.Magnitude magnitude, Map.Entry<Instant, Double> entry, Formatter formatter, Map<Instant, List<TimelineDatasource.Annotation>> annotations) {
        TimelineHistoryEntry result = new TimelineHistoryEntry();
        Double percentage = this.historyWithRelativeValues ? this.percentage(magnitude, entry.getValue()) : null;
        result.date(entry.getKey());
        result.value(Double.isNaN(entry.getValue()) ? null : String.valueOf(this.historyWithRelativeValues ? this.percentage(magnitude, entry.getValue()) : entry.getValue()));
        result.formattedValue(this.adapt(formatter.format(percentage != null ? percentage : entry.getValue())));
        result.annotation(annotations.containsKey(entry.getKey()) ? this.annotationOf(this.date(this.normalize(entry.getKey()), this.selectedScale()), annotations.get(entry.getKey())) : null);
        return result;
    }

    private Double percentage(TimelineDatasource.Magnitude magnitude, Double value) {
        Double max = magnitude.max();
        if (max == null) {
            return null;
        }
        return value * 100.0 / max;
    }

    private TimelineSummary summaryOf(TimelineDatasource.Magnitude magnitude) {
        Scale scale = this.selectedScale();
        Formatter formatter = magnitude.definition().formatter();
        Instant date = this.selectedInstant(scale);
        TimelineDatasource.Summary summary = magnitude.summary(date, scale);
        return new TimelineSummary().average(this.summaryValueOf(summary.average(), date, formatter)).max(this.summaryValueOf(summary.max(), summary.maxDate(), formatter)).min(this.summaryValueOf(summary.min(), summary.minDate(), formatter)).attributes(this.summaryAttributes(summary.attributes(), formatter));
    }

    private List<TimelineSummaryAttribute> summaryAttributes(List<TimelineDatasource.Summary.Attribute> attributes, Formatter formatter) {
        return attributes.stream().map(a -> this.summaryAttribute((TimelineDatasource.Summary.Attribute)a, formatter)).collect(Collectors.toList());
    }

    private TimelineSummaryAttribute summaryAttribute(TimelineDatasource.Summary.Attribute attribute, Formatter formatter) {
        return new TimelineSummaryAttribute().name(attribute.name()).value(this.summaryValueOf(attribute.value(), attribute.date(), formatter));
    }

    private TimelineSummaryValue summaryValueOf(double value, Instant date, Formatter formatter) {
        return new TimelineSummaryValue().value(Double.isNaN(value) ? null : this.adapt(formatter.format(value))).date(date);
    }

    private TimelineSerie serieOf(TimelineDatasource.Magnitude magnitude) {
        TimelineSerie result = new TimelineSerie();
        Scale scale = this.selectedScale();
        Instant current = this.selectedInstant(scale);
        TimelineDatasource.Serie serie = magnitude.serie(scale, current, this.summaryPointsCount);
        List<Double> values = this.loadValues(magnitude, serie);
        Formatter formatter = magnitude.definition().formatter();
        result.name(serie.name());
        result.categories(this.categoriesOf(serie, current, scale));
        result.values(this.replaceNaNs(values));
        result.annotations(this.annotationsOf(serie, current, scale));
        result.formattedValues(values.stream().map(formatter::format).collect(Collectors.toList()));
        return result;
    }

    private List<Double> replaceNaNs(List<Double> values) {
        return values.stream().map(v -> Double.isNaN(v) ? null : v).collect(Collectors.toList());
    }

    private List<String> categoriesOf(TimelineDatasource.Serie serie, Instant to, Scale scale) {
        return this.loadCategories(serie, to, scale).stream().map(d -> this.date((Instant)d, scale)).collect(Collectors.toList());
    }

    private List<TimelineAnnotation> annotationsOf(TimelineDatasource.Serie serie, Instant to, Scale scale) {
        List<Instant> instantList = this.loadCategories(serie, to, scale);
        Map annotationList = serie.annotations().entrySet().stream().collect(Collectors.toMap(e -> this.normalize((Instant)e.getKey()), Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new));
        return instantList.stream().map(i -> this.annotationOf(this.date((Instant)i, scale), annotationList.getOrDefault(this.normalize((Instant)i), Collections.emptyList()))).collect(Collectors.toList());
    }

    private Instant normalize(Instant instant) {
        return new Timetag(instant, this.selectedScale()).instant();
    }

    private TimelineAnnotation annotationOf(String category, List<TimelineDatasource.Annotation> annotationList) {
        if (annotationList.isEmpty()) {
            return null;
        }
        TimelineDatasource.Annotation annotation = annotationList.get(0);
        return new TimelineAnnotation().category(category).color(annotation.color()).symbol(annotation.symbol().name().toLowerCase()).entries(this.annotationEntriesOf(annotationList));
    }

    private List<String> annotationEntriesOf(List<TimelineDatasource.Annotation> annotationList) {
        return annotationList.stream().map(TimelineDatasource.Annotation::label).collect(Collectors.toList());
    }

    private List<Instant> loadCategories(TimelineDatasource.Serie serie, Instant to, Scale scale) {
        ArrayList<Instant> result = new ArrayList<Instant>(serie.values().keySet());
        return this.reverse(this.fill(this.reverse(result).subList(0, Math.min(result.size(), this.summaryPointsCount)), to, scale));
    }

    private List<Double> loadValues(TimelineDatasource.Magnitude magnitude, TimelineDatasource.Serie serie) {
        boolean renderPercentages = magnitude.percentage() != null;
        List values = serie.values().values().stream().map(v -> renderPercentages ? this.percentage(magnitude, (Double)v) : v).collect(Collectors.toList());
        return this.reverse(this.fillWithZeros(this.reverse(values).subList(0, Math.min(values.size(), this.summaryPointsCount))));
    }

    private TimelineDatasource.Magnitude magnitude(MagnitudeDefinition definition) {
        return this.source.magnitude(definition);
    }

    private List<Instant> fill(List<Instant> result, Instant to, Scale scale) {
        if (result.size() >= this.summaryPointsCount) {
            return result;
        }
        LocalDateTime mockDate = LocalDateTime.ofInstant(result.isEmpty() ? to : result.get(result.size() - 1), ZoneOffset.UTC);
        while (result.size() < this.summaryPointsCount) {
            mockDate = mockDate.minus(1L, this.chronoUnitOf(scale));
            result.add(mockDate.toInstant(ZoneOffset.UTC));
        }
        return result;
    }

    private TemporalUnit chronoUnitOf(Scale scale) {
        if (scale == Scale.Hour) {
            return ChronoUnit.HOURS;
        }
        if (scale == Scale.Minute) {
            return ChronoUnit.MINUTES;
        }
        if (scale == Scale.Day) {
            return ChronoUnit.DAYS;
        }
        if (scale == Scale.Week) {
            return ChronoUnit.WEEKS;
        }
        if (scale == Scale.Month) {
            return ChronoUnit.MONTHS;
        }
        return ChronoUnit.YEARS;
    }

    private Map<Instant, Double> fillWithZeros(Map<Instant, Double> result, Instant to, Scale scale) {
        if (result.size() >= this.summaryPointsCount) {
            return result;
        }
        LocalDateTime mockDate = LocalDateTime.ofInstant(result.isEmpty() ? to : new ArrayList<Instant>(result.keySet()).get(0), ZoneOffset.UTC);
        while (result.size() < this.summaryPointsCount) {
            mockDate = mockDate.minus(1L, this.chronoUnitOf(scale));
            result.put(mockDate.toInstant(ZoneOffset.UTC), 0.0);
        }
        ArrayList<Instant> keys = new ArrayList<Instant>(result.keySet());
        keys.sort(Instant::compareTo);
        return keys.stream().collect(Collectors.toMap(k -> k, result::get, (k, v) -> k, LinkedHashMap::new));
    }

    private List<Double> fillWithZeros(List<Double> result) {
        if (result.size() >= this.summaryPointsCount) {
            return result;
        }
        while (result.size() < this.summaryPointsCount) {
            result.add(0.0);
        }
        return result;
    }

    private <T> List<T> reverse(List<T> result) {
        Collections.reverse(result);
        return result;
    }

    private String date(Instant date, Scale scale) {
        return ScaleFormatter.shortLabel(date, this.timezoneOffset(), scale, this.language());
    }

    public String date(Instant date, String format, Function<String, String> translator) {
        if (date == null) {
            return null;
        }
        return Timeline.formatDate(translator.apply(format), date, Timeline.locale(this.language()));
    }

    private static String formatDate(String pattern, Instant instant, Locale locale) {
        SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
        return format.format(Date.from(instant));
    }

    private static Locale locale(String language) {
        if (language.toLowerCase().contains("es")) {
            return new Locale("es", "ES");
        }
        if (language.toLowerCase().contains("pt")) {
            return new Locale("pt", "PT");
        }
        return new Locale("en", "EN");
    }

    private Instant selectedInstant(String scale) {
        return this.selectedInstant(Scale.valueOf((String)scale));
    }

    private Instant selectedInstant(Scale scale) {
        return this.selectedInstants.getOrDefault(scale, this.source.to(this.selectedScale()));
    }

    private Scale selectedScale() {
        return this.selectedScale != null ? this.selectedScale : this.source.scales().get(0);
    }

    private void selectInstant(Scale scale, Instant value) {
        this.selectedInstants.put(scale, value);
        this.refreshMagnitudes();
        if (this.selectListener != null) {
            this.selectListener.accept(new SelectEvent(this, value));
        }
    }

    private void refreshMagnitudes() {
        ((TimelineNotifier)this.notifier).refreshMagnitudes(this.source.magnitudes().stream().map(this::schemaOf).collect(Collectors.toList()));
    }

    private TimelineMagnitude schemaOf(MagnitudeDefinition definition) {
        return this.schemaOf(this.magnitude(definition));
    }

    private TimelineMagnitude schemaOf(TimelineDatasource.Magnitude magnitude) {
        MagnitudeDefinition definition = magnitude.definition();
        Formatter formatter = definition.formatter();
        double value = magnitude.value();
        return new TimelineMagnitude().name(definition.name()).value(String.valueOf(value)).formattedValue(!Double.isNaN(value) ? this.adapt(formatter.format(value)) : "-").status(magnitude.status() != null ? magnitude.status().name() : null).min(magnitude.min() != null ? String.valueOf(magnitude.min()) : null).formattedMin(magnitude.min() != null ? this.adapt(formatter.format(magnitude.min())) : null).max(magnitude.max() != null ? String.valueOf(magnitude.max()) : null).formattedMax(magnitude.max() != null ? this.adapt(formatter.format(magnitude.max())) : null).percentage(magnitude.percentage() != null ? this.adapt(formatter.format(magnitude.percentage())) : null).label(definition.label(this.language())).unit(this.translate(definition.unit())).summary(this.summaryOf(magnitude)).serie(this.serieOf(magnitude)).customView(magnitude.customHtmlView(this.selectedScale()));
    }

    private String adapt(String value) {
        if (!EnglishNotationLanguages.contains(this.language().toLowerCase())) {
            return value;
        }
        return value.replace(",", "COMMA").replace(".", ",").replace("COMMA", ".");
    }

    public static enum Mode {
        Summary,
        Catalog;

    }
}

