/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.components.AbstractSelectPreviousItem;
import io.intino.alexandria.ui.displays.components.Collection;
import io.intino.alexandria.ui.displays.events.SelectionListener;
import io.intino.alexandria.ui.displays.events.actionable.SelectItemListener;
import io.intino.alexandria.ui.displays.events.collection.RefreshListener;
import io.intino.alexandria.ui.displays.events.collection.SelectItemEvent;
import io.intino.alexandria.ui.displays.notifiers.SelectPreviousItemNotifier;

public class SelectPreviousItem<DN extends SelectPreviousItemNotifier, B extends Box>
extends AbstractSelectPreviousItem<DN, B> {
    private Collection collection;
    private SelectItemListener selectItemListener = null;

    public SelectPreviousItem(B box) {
        super(box);
    }

    public SelectPreviousItem onSelect(SelectItemListener listener) {
        this.selectItemListener = listener;
        return this;
    }

    public SelectPreviousItem bindTo(Collection collection) {
        if (collection != null) {
            this.releaseFrom(collection);
        }
        this.collection = collection;
        this.collection.onRefresh(e -> this.readonly(!collection.canSelectPreviousItem()));
        this.collection.addSelectionListener(event -> this.readonly(!collection.canSelectPreviousItem()));
        return this;
    }

    public void execute() {
        if (this.collection == null) {
            return;
        }
        Object item = this.collection.selectPreviousItem();
        if (this.selectItemListener != null) {
            this.selectItemListener.accept(new SelectItemEvent(this, this.collection, item));
        }
    }

    private void releaseFrom(Collection collection) {
        collection.unRefresh(this.refreshListener(collection));
        collection.removeSelectionListener(this.selectionListener(collection));
    }

    private SelectionListener selectionListener(Collection collection) {
        return event -> this.readonly(!collection.canSelectNextItem());
    }

    private RefreshListener refreshListener(Collection collection) {
        return e -> this.readonly(!collection.canSelectNextItem());
    }
}

