package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.OpenDrawer;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class OpenDrawerRequester extends ActionableRequester {

	public OpenDrawerRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		OpenDrawer display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("execute")) {
			display.execute();
			return;
		}

		super.execute();
	}
}