package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.ImageEditable;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class ImageEditableRequester extends BaseImageRequester {

	public ImageEditableRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		ImageEditable display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("notifyUploading")) {
			display.notifyUploading();
			return;
		}
		else if (operation.equals("notifyChange")) {
			display.notifyChange(manager.fromFormAsResource("v"));
			return;
		}
		else if (operation.equals("download")) {
			io.intino.alexandria.ui.server.UIFile file = display.download();
			if (file == null) return;
			manager.write(file.content(), file.label(), file.embedded());
			return;
		}

		super.execute();
	}
}