package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.DateNavigator;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class DateNavigatorRequester extends io.intino.alexandria.ui.displays.requesters.ComponentRequester {

	public DateNavigatorRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		DateNavigator display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("first")) {
			display.first();
			return;
		}
		else if (operation.equals("previous")) {
			display.previous();
			return;
		}
		else if (operation.equals("next")) {
			display.next();
			return;
		}
		else if (operation.equals("last")) {
			display.last();
			return;
		}
		else if (operation.equals("select")) {
			display.select(manager.fromQuery("v") != null ? java.time.Instant.ofEpochMilli(Long.parseLong(manager.fromQuery("v"))) : null);
			return;
		}
		else if (operation.equals("changeScale")) {
			display.changeScale(manager.fromQuery("v"));
			return;
		}

		super.execute();
	}
}