/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.WizardNavigatorInfo;
import io.intino.alexandria.ui.displays.Component;
import io.intino.alexandria.ui.displays.components.AbstractWizardNavigator;
import io.intino.alexandria.ui.displays.components.Step;
import io.intino.alexandria.ui.displays.components.Wizard;
import io.intino.alexandria.ui.displays.notifiers.WizardNavigatorNotifier;
import java.util.List;
import java.util.stream.Collectors;

public class WizardNavigator<DN extends WizardNavigatorNotifier, B extends Box>
extends AbstractWizardNavigator<B> {
    private Wizard<?, ?> wizard;
    private String confirmMessage;

    public WizardNavigator(B box) {
        super(box);
    }

    public WizardNavigator<DN, B> bindTo(Wizard<?, ?> wizard) {
        this.wizard = wizard;
        this.wizard.onStepArrival(e -> this.refresh());
        this.wizard.onFinish(e -> this.refresh());
        return this;
    }

    public void back() {
        this.wizard.back();
        this.refresh();
    }

    public void select(Integer pos) {
        this.wizard.select(pos);
        this.refresh();
    }

    public void next() {
        this.wizard.next();
        this.refresh();
    }

    public void finish() {
        this.wizard.finish();
        this.refresh();
    }

    @Override
    public void refresh() {
        super.refresh();
        ((WizardNavigatorNotifier)this.notifier).refresh(this.info());
    }

    protected void _confirmMessage(String message) {
        this.confirmMessage = message;
    }

    private WizardNavigatorInfo info() {
        return new WizardNavigatorInfo().active(this.wizard.active()).stepsCount(this.visibleSteps().size()).allowNext(this.wizard.allowNext()).allowBack(this.wizard.allowBack()).allowFinish(this.wizard.allowFinish()).finished(this.wizard.finished());
    }

    private List<Step> visibleSteps() {
        return this.wizard.steps().stream().filter(Component::isVisible).collect(Collectors.toList());
    }
}

