/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.intino.alexandria.Json;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.restaccessor.core.RestAccessor;
import io.intino.alexandria.restaccessor.exceptions.RestfulFailure;
import io.intino.alexandria.schemas.ProxyDisplayInfo;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.notifiers.ProxyDisplayNotifier;
import io.intino.alexandria.ui.server.pages.Unit;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UISession;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public abstract class ProxyDisplay<DN extends ProxyDisplayNotifier>
extends Display<DN, Box> {
    private final String type;
    private final Unit unit;
    private final String path;
    private String sessionId;
    private String clientId;
    private String token;
    private boolean ready = false;
    private final Set<PendingRequest> pendingRequestList = new LinkedHashSet<PendingRequest>();
    private Map<String, String> parameters = new HashMap<String, String>();
    private final Map<String, Consumer<Boolean>> messageListeners = new HashMap<String, Consumer<Boolean>>();
    private static final Map<String, String> errorMessages = new HashMap<String, String>(){
        {
            this.put("es", "No se pudo conectar con %s");
            this.put("en", "Could not connect with %s");
        }
    };

    public ProxyDisplay(String type, Unit unit, String path) {
        super(null);
        this.type = type;
        this.unit = unit;
        this.path = path;
    }

    public ProxyDisplay<DN> session(UISession session) {
        this.sessionId = session.id();
        this.clientId = session.client() != null ? ((UIClient)session.client()).id() : null;
        this.token = session.token() != null ? session.token().id() : null;
        return this;
    }

    public ProxyMessageListener onMessage(String name) {
        return listener -> {
            this.messageListeners.put(name, listener);
            return this;
        };
    }

    @Override
    public void refresh() {
        try {
            if (this.sessionId == null || this.clientId == null) {
                throw new RuntimeException("You must set session to start this component");
            }
            if (!this.ready) {
                return;
            }
            this.post("?operation=refreshPersonifiedDisplay", this.parameters());
        }
        catch (RestfulFailure | MalformedURLException error) {
            ((ProxyDisplayNotifier)this.notifier).refreshError(this.errorMessage(this.unit.url()));
        }
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public ProxyDisplay parameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public ProxyDisplay add(String name, String value) {
        this.parameters.put(name, value);
        return this;
    }

    @Override
    public void init() {
        super.init();
        ((ProxyDisplayNotifier)this.notifier).refresh(new ProxyDisplayInfo().unit(this.unit.name()).display(new ProxyDisplayInfo.Display().id(this.id() + "_").type(this.type)));
    }

    protected void request(String operation) {
        this.request(operation, null);
    }

    protected void request(String operation, Object object) {
        try {
            if (!this.ready) {
                this.pendingRequestList.add(new PendingRequest().operation(operation).parameter(object));
                return;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            if (object != null) {
                map.put("value", this.serializeParameter(object).toString());
            }
            this.post("?operation=" + operation, map);
        }
        catch (RestfulFailure | MalformedURLException error) {
            ((ProxyDisplayNotifier)this.notifier).refreshError(this.errorMessage(this.unit.url()));
        }
    }

    public void connected() {
        try {
            this.post("/personify", this.parameters());
        }
        catch (RestfulFailure | MalformedURLException error) {
            ((ProxyDisplayNotifier)this.notifier).refreshError(this.errorMessage(this.unit.url()));
        }
    }

    public void ready() {
        this.ready = true;
        this.processPendingRequests();
    }

    protected String errorMessage(String application) {
        String language = this.language();
        if (!errorMessages.containsKey(language)) {
            language = "en";
        }
        return String.format(errorMessages.get(language), application);
    }

    private void post(String subPath, Map<String, String> parameters) throws MalformedURLException, RestfulFailure {
        URL unitUrl = new URL(this.unit.url());
        new RestAccessor().post(unitUrl, this.path + "/" + this.id() + subPath, this.withInternalParameters(parameters));
    }

    private JsonElement serializeParameter(Object value) {
        String result = Json.toString((Object)value);
        try {
            return (JsonElement)Json.fromString((String)result, JsonElement.class);
        }
        catch (Exception var4) {
            return new JsonPrimitive(result);
        }
    }

    private void processPendingRequests() {
        this.pendingRequestList.forEach(r -> this.request(r.operation, r.parameter));
        this.pendingRequestList.clear();
    }

    private Map<String, String> withInternalParameters(Map<String, String> parameters) {
        HashMap<String, String> result = new HashMap<String, String>();
        parameters.forEach(result::put);
        result.put("client", this.clientId);
        result.put("session", this.sessionId);
        result.put("language", this.language());
        result.put("token", this.token);
        result.put("personifiedDisplay", this.id() + "_");
        return result;
    }

    private String language() {
        UIClient client = (UIClient)this.session().client();
        if (client != null) {
            return client.language();
        }
        return this.session().discoverLanguage();
    }

    public void notifyMessage(String name) {
        if (!this.messageListeners.containsKey(name)) {
            return;
        }
        this.messageListeners.get(name).accept(true);
    }

    public static interface ProxyMessageListener {
        public ProxyDisplay<?> then(Consumer<Boolean> var1);
    }

    private class PendingRequest {
        private String operation;
        private Object parameter;

        private PendingRequest() {
        }

        PendingRequest operation(String operation) {
            this.operation = operation;
            return this;
        }

        PendingRequest parameter(Object parameter) {
            this.parameter = parameter;
            return this;
        }
    }
}

