package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.Chat;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class ChatRequester extends io.intino.alexandria.ui.displays.requesters.ComponentRequester {

	public ChatRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		Chat display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("sendMessage")) {
			display.sendMessage(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.ChatSendMessageInfo.class));
			return;
		}
		else if (operation.equals("sendAttachment")) {
			display.sendAttachment(manager.fromQuery("v"));
			return;
		}
		else if (operation.equals("uploadAttachment")) {
			display.uploadAttachment(manager.fromFormAsResource("v"));
			return;
		}
		else if (operation.equals("previousMessages")) {
			display.previousMessages();
			return;
		}

		super.execute();
	}
}