/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.Component;
import io.intino.alexandria.ui.displays.components.AbstractBlockConditional;
import io.intino.alexandria.ui.displays.components.ActionToggle;
import io.intino.alexandria.ui.displays.components.selector.Selection;
import io.intino.alexandria.ui.displays.components.selector.Selector;
import io.intino.alexandria.ui.displays.events.Event;
import io.intino.alexandria.ui.displays.events.Listener;
import io.intino.alexandria.ui.displays.events.actionable.ToggleEvent;
import io.intino.alexandria.ui.displays.notifiers.BlockConditionalNotifier;
import java.util.List;

public abstract class BlockConditional<DN extends BlockConditionalNotifier, B extends Box>
extends AbstractBlockConditional<B>
implements Selection {
    private boolean initialized = false;
    private Listener initListener = null;

    public BlockConditional(B box) {
        super(box);
        this.updateVisible(false);
    }

    @Override
    public void add(Component container) {
        super.add(container);
    }

    public BlockConditional<DN, B> onInit(Listener listener) {
        this.initListener = listener;
        return this;
    }

    public BlockConditional<DN, B> focus() {
        ((BlockConditionalNotifier)this.notifier).refreshFocused(true);
        return this;
    }

    @Override
    public void bindTo(Selector selector, String option) {
        this.updateVisibility(selector, option);
        selector.onSelect(e -> this.updateVisibility(e.selection().contains(option)));
    }

    @Override
    public void bindTo(ActionToggle action, String option) {
        this.updateVisibility(action, option);
        action.onToggle(e -> this.updateVisibility(e.state() == ToggleEvent.State.On));
    }

    public abstract void initConditional();

    @Override
    protected void updateVisibility(boolean value) {
        this.updateVisible(value);
        ((BlockConditionalNotifier)this.notifier).refreshVisibility(value);
        if (this.isVisible()) {
            this.initComponent();
        }
        this.notifyVisibility();
    }

    private void updateVisibility(Selector selector, String option) {
        if (selector == null) {
            return;
        }
        List selection = selector.selection();
        if (selection.size() <= 0 || !selection.contains(option)) {
            return;
        }
        this.updateVisibility(true);
    }

    private void updateVisibility(ActionToggle action, String option) {
        if (action == null) {
            return;
        }
        ToggleEvent.State state = action.state();
        this.updateVisibility(state == ToggleEvent.State.On);
    }

    protected void initComponent() {
        if (this.initialized) {
            return;
        }
        this.initConditional();
        if (this.initListener != null) {
            this.initListener.accept(new Event(this));
        }
        this.initialized = true;
    }
}

