package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.Reel;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class ReelRequester extends io.intino.alexandria.ui.displays.requesters.ComponentRequester {

	public ReelRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		Reel display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("fetch")) {
			display.fetch(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.ReelFetch.class));
			return;
		}
		else if (operation.equals("signalsSorting")) {
			display.signalsSorting(java.util.List.of(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.ReelSignalSorting[].class)));
			return;
		}

		super.execute();
	}
}