/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.server;

import io.intino.alexandria.http.AlexandriaHttpServer;
import io.intino.alexandria.http.pushservice.PushService;
import io.intino.alexandria.http.server.AlexandriaHttpManager;
import io.intino.alexandria.http.server.AlexandriaHttpRouter;
import io.intino.alexandria.ui.server.AlexandriaUiManager;
import io.intino.alexandria.ui.services.AuthService;
import java.util.function.Consumer;
import java.util.function.Function;

public class UIRouter
implements AlexandriaHttpRouter<AlexandriaUiManager> {
    private final AlexandriaHttpRouter<AlexandriaUiManager> router;
    private final AuthService authService;
    private static boolean hasUserHome = false;

    public UIRouter(AlexandriaHttpRouter<AlexandriaUiManager> router, String path, AuthService authService) {
        this.router = router;
        if (this.isUserHomePath(path)) {
            hasUserHome = true;
        }
        this.authService = authService;
        this.managerProvider((AlexandriaHttpRouter.ManagerProvider<AlexandriaUiManager>)((AlexandriaHttpRouter.ManagerProvider)(request, response) -> new AlexandriaUiManager((io.intino.alexandria.ui.services.push.PushService)this.pushService(), request, response, authService, hasUserHome)));
    }

    private boolean isUserHomePath(String path) {
        return path.contains("/konos/user");
    }

    public AlexandriaHttpRouter<AlexandriaUiManager> before(AlexandriaHttpServer.ResourceCaller<AlexandriaUiManager> caller) {
        return this.router.before(caller);
    }

    public AlexandriaHttpRouter<AlexandriaUiManager> get(AlexandriaHttpServer.ResourceCaller<AlexandriaUiManager> caller) {
        return this.router.get(caller);
    }

    public AlexandriaHttpRouter<AlexandriaUiManager> post(AlexandriaHttpServer.ResourceCaller<AlexandriaUiManager> caller) {
        return this.router.post(caller);
    }

    public AlexandriaHttpRouter<AlexandriaUiManager> put(AlexandriaHttpServer.ResourceCaller<AlexandriaUiManager> caller) {
        return this.router.put(caller);
    }

    public AlexandriaHttpRouter<AlexandriaUiManager> delete(AlexandriaHttpServer.ResourceCaller<AlexandriaUiManager> caller) {
        return this.router.delete(caller);
    }

    public AlexandriaHttpRouter<AlexandriaUiManager> patch(AlexandriaHttpServer.ResourceCaller<AlexandriaUiManager> caller) {
        return this.router.patch(caller);
    }

    public AlexandriaHttpRouter<AlexandriaUiManager> after(AlexandriaHttpServer.ResourceCaller<AlexandriaUiManager> caller) {
        return this.router.after(caller);
    }

    public PushService<?, ?> pushService() {
        return this.router.pushService();
    }

    public void push(PushService<?, ?> service) {
        this.router.push(service);
    }

    public void register(PushService<?, ?> service) {
        this.router.register(service);
    }

    public void managerProvider(AlexandriaHttpRouter.ManagerProvider<AlexandriaUiManager> provider) {
        this.router.managerProvider(provider);
    }

    public void whenRegisterPushService(Consumer<PushService<?, ?>> pushServiceConsumer) {
        this.router.whenRegisterPushService(pushServiceConsumer);
    }

    public void whenValidate(Function<AlexandriaHttpManager<?>, Boolean> validator) {
        this.router.whenValidate(validator);
    }
}

