/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.templates;

import io.intino.alexandria.Scale;
import io.intino.alexandria.UiFrameworkBox;
import io.intino.alexandria.ui.displays.templates.AbstractTimelineExamplesMold;
import io.intino.alexandria.ui.model.timeline.MagnitudeDefinition;
import io.intino.alexandria.ui.model.timeline.TimelineDatasource;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TimelineExamplesMold
extends AbstractTimelineExamplesMold<UiFrameworkBox> {
    public TimelineExamplesMold(UiFrameworkBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        this.timeline1.source(this.source());
        this.timeline1.refresh();
        this.timeline2.source(this.source());
        this.timeline2.refresh();
    }

    private TimelineDatasource source() {
        return new TimelineDatasource(){

            @Override
            public String name() {
                return "tds1";
            }

            @Override
            public List<MagnitudeDefinition> magnitudes() {
                return List.of(TimelineExamplesMold.this.measurementOf("m1", "%", "Medida 1"), TimelineExamplesMold.this.measurementOf("m2", "\u20ac", "Medida 2"));
            }

            @Override
            public TimelineDatasource.Magnitude magnitude(MagnitudeDefinition definition) {
                if (definition.name().equalsIgnoreCase("m1")) {
                    return TimelineExamplesMold.this.m1(definition);
                }
                return TimelineExamplesMold.this.m2(definition);
            }

            @Override
            public List<Scale> scales() {
                return List.of(Scale.Minute, Scale.Hour, Scale.Day, Scale.Week, Scale.Month, Scale.Year);
            }

            @Override
            public Instant from(Scale scale) {
                return LocalDateTime.ofInstant(Instant.now(), ZoneOffset.UTC).minus(30L, scale.temporalUnit()).toInstant(ZoneOffset.UTC);
            }

            @Override
            public Instant to(Scale scale) {
                return Instant.now();
            }
        };
    }

    private TimelineDatasource.Magnitude m1(final MagnitudeDefinition definition) {
        return new TimelineDatasource.Magnitude(){

            @Override
            public TimelineDatasource.Summary summary(Instant date, Scale scale) {
                return new TimelineDatasource.Summary(){

                    @Override
                    public double average() {
                        return 10.0;
                    }

                    @Override
                    public Instant averageDate() {
                        return Instant.now();
                    }

                    @Override
                    public double max() {
                        return 100.0;
                    }

                    @Override
                    public Instant maxDate() {
                        return Instant.now();
                    }

                    @Override
                    public double min() {
                        return 2.0;
                    }

                    @Override
                    public Instant minDate() {
                        return Instant.now();
                    }
                };
            }

            @Override
            public MagnitudeDefinition definition() {
                return definition;
            }

            @Override
            public TimelineDatasource.Magnitude.Status status() {
                return TimelineDatasource.Magnitude.Status.Warning;
            }

            @Override
            public double value() {
                return 11.0;
            }

            @Override
            public Double min() {
                return null;
            }

            @Override
            public Double max() {
                return null;
            }

            @Override
            public Double percentage() {
                return null;
            }

            @Override
            public TimelineDatasource.Serie serie(final Scale scale, Instant instant) {
                final LocalDateTime date = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
                return new TimelineDatasource.Serie(){

                    @Override
                    public String name() {
                        return "Evoluci\u00f3n";
                    }

                    @Override
                    public Map<Instant, Double> values() {
                        return new LinkedHashMap<Instant, Double>(){
                            {
                                this.put(date.minus(8L, scale.temporalUnit()).toInstant(ZoneOffset.UTC), 120.0);
                                this.put(date.minus(7L, scale.temporalUnit()).toInstant(ZoneOffset.UTC), 100.0);
                                this.put(date.minus(6L, scale.temporalUnit()).toInstant(ZoneOffset.UTC), 10.0);
                                this.put(date.minus(5L, scale.temporalUnit()).toInstant(ZoneOffset.UTC), 20.0);
                                this.put(date.minus(4L, scale.temporalUnit()).toInstant(ZoneOffset.UTC), 1220.0);
                                this.put(date.minus(3L, scale.temporalUnit()).toInstant(ZoneOffset.UTC), 192.0);
                                this.put(date.minus(2L, scale.temporalUnit()).toInstant(ZoneOffset.UTC), 1232.0);
                                this.put(date.minus(1L, scale.temporalUnit()).toInstant(ZoneOffset.UTC), 12.0);
                                this.put(date.toInstant(ZoneOffset.UTC), 12.0);
                            }
                        };
                    }

                    @Override
                    public Map<Instant, List<TimelineDatasource.Annotation>> annotations() {
                        return new LinkedHashMap<Instant, List<TimelineDatasource.Annotation>>(){
                            {
                                this.put(date.minus(5L, scale.temporalUnit()).toInstant(ZoneOffset.UTC), List.of(this.annotationOf("Warning value")));
                                this.put(date.minus(4L, scale.temporalUnit()).toInstant(ZoneOffset.UTC), List.of(this.annotationOf("Out of range", "red"), this.annotationOf("Other error", "red")));
                                this.put(date.minus(1L, scale.temporalUnit()).toInstant(ZoneOffset.UTC), List.of(this.annotationOf("Value is not valid", "green")));
                            }

                            private TimelineDatasource.Annotation annotationOf(String label) {
                                return new TimelineDatasource.Annotation(label);
                            }

                            private TimelineDatasource.Annotation annotationOf(String label, String color) {
                                return new TimelineDatasource.Annotation(label, color);
                            }
                        };
                    }
                };
            }

            @Override
            public TimelineDatasource.Serie serie(Scale scale, Instant start, Instant end) {
                return this.serie(scale, end);
            }

            @Override
            public String customHtmlView(Scale scale) {
                return "<div style=\"width:100%\">soy un custom view</div>";
            }
        };
    }

    private TimelineDatasource.Magnitude m2(final MagnitudeDefinition definition) {
        return new TimelineDatasource.Magnitude(){

            @Override
            public TimelineDatasource.Summary summary(Instant date, Scale scale) {
                return new TimelineDatasource.Summary(){

                    @Override
                    public double average() {
                        return 35.0;
                    }

                    @Override
                    public Instant averageDate() {
                        return Instant.now();
                    }

                    @Override
                    public double max() {
                        return 92.0;
                    }

                    @Override
                    public Instant maxDate() {
                        return Instant.now();
                    }

                    @Override
                    public double min() {
                        return 10.0;
                    }

                    @Override
                    public Instant minDate() {
                        return Instant.now();
                    }
                };
            }

            @Override
            public MagnitudeDefinition definition() {
                return definition;
            }

            @Override
            public TimelineDatasource.Magnitude.Status status() {
                return TimelineDatasource.Magnitude.Status.Normal;
            }

            @Override
            public double value() {
                return 3300.0;
            }

            @Override
            public Double min() {
                return -10000.0;
            }

            @Override
            public Double max() {
                return 10000.0;
            }

            @Override
            public Double percentage() {
                return 16.5;
            }

            @Override
            public TimelineDatasource.Serie serie(Scale scale, Instant date) {
                return new TimelineDatasource.Serie(){

                    @Override
                    public String name() {
                        return "Evoluci\u00f3n";
                    }

                    @Override
                    public Map<Instant, Double> values() {
                        return Collections.emptyMap();
                    }

                    @Override
                    public Map<Instant, List<TimelineDatasource.Annotation>> annotations() {
                        return Collections.emptyMap();
                    }
                };
            }

            @Override
            public TimelineDatasource.Serie serie(Scale scale, Instant start, Instant end) {
                return new TimelineDatasource.Serie(){

                    @Override
                    public String name() {
                        return "Evoluci\u00f3n";
                    }

                    @Override
                    public Map<Instant, Double> values() {
                        return Collections.emptyMap();
                    }

                    @Override
                    public Map<Instant, List<TimelineDatasource.Annotation>> annotations() {
                        return Collections.emptyMap();
                    }
                };
            }

            @Override
            public String customHtmlView(Scale scale) {
                return null;
            }
        };
    }

    private MagnitudeDefinition measurementOf(String name, String unit, String label) {
        return new MagnitudeDefinition().name(name).unit(unit).add("es", label);
    }
}

