/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.Component;
import io.intino.alexandria.ui.displays.components.AbstractSelectorListBox;
import io.intino.alexandria.ui.displays.notifiers.SelectorListBoxNotifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SelectorListBox<DN extends SelectorListBoxNotifier, B extends Box>
extends AbstractSelectorListBox<DN, B> {
    private List<String> selection = new ArrayList<String>();
    private Set<String> hiddenOptions = new HashSet<String>();

    public SelectorListBox(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        super.didMount();
        this.selection(this.selection);
    }

    public void show(Component<?, ?> option) {
        this.hiddenOptions.remove(option.id());
        option.visible(true);
        ((SelectorListBoxNotifier)this.notifier).refreshHiddenOptions(new ArrayList<String>(this.hiddenOptions));
    }

    public void hide(Component<?, ?> option) {
        this.hiddenOptions.add(option.id());
        option.visible(false);
        ((SelectorListBoxNotifier)this.notifier).refreshHiddenOptions(new ArrayList<String>(this.hiddenOptions));
    }

    public void visible(Component<?, ?> option, boolean value) {
        if (value) {
            this.show(option);
        } else {
            this.hide(option);
        }
    }

    public List<String> selection() {
        return this.selection;
    }

    @Override
    public void reset() {
        this.select(new String[0]);
    }

    public void selection(String ... options) {
        this.selection(Arrays.asList(options));
    }

    public void selection(List<String> selection) {
        this.selection = selection;
        ((SelectorListBoxNotifier)this.notifier).refreshSelection(this.selection);
    }

    public void select(String ... options) {
        this.updateSelection(Arrays.asList(options));
    }

    public void updateSelection(List<String> options) {
        this.selection(options);
        this.notifySelection();
    }
}

