/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.MimeTypes;
import io.intino.alexandria.Resource;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.Attachment;
import io.intino.alexandria.schemas.ChatInfo;
import io.intino.alexandria.schemas.ChatMessage;
import io.intino.alexandria.schemas.ChatSendMessageInfo;
import io.intino.alexandria.ui.displays.components.AbstractChat;
import io.intino.alexandria.ui.displays.notifiers.ChatNotifier;
import io.intino.alexandria.ui.model.chat.ChatDatasource;
import io.intino.alexandria.ui.model.chat.Message;
import io.intino.alexandria.ui.model.chat.MessageReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Chat<DN extends ChatNotifier, B extends Box>
extends AbstractChat<B> {
    private ChatDatasource source;
    private MessageReader reader;
    private String condition;
    private Resource attachment;
    private URL incomingImage;
    private URL outgoingImage;
    private URL loadingImage;
    private String emptyMessage;
    private static final int PageSize = 50;

    public Chat(B box) {
        super(box);
    }

    public <CP extends ChatDatasource> Chat<DN, B> source(CP value) {
        this.source = value;
        return this;
    }

    public Chat<DN, B> open() {
        ((ChatNotifier)this.notifier).open();
        return this;
    }

    public Chat<DN, B> emptyMessage(String message) {
        this._emptyMessage(message);
        return this;
    }

    public void uploadAttachment(Resource value) {
        this.attachment = value;
    }

    @Override
    public void add(Message message) {
        ((ChatNotifier)this.notifier).addMessages(List.of(this.schemaOf(message)));
    }

    public void sendMessage(ChatSendMessageInfo info) {
        this.add(Message.with(info.displayMessage() != null ? info.displayMessage() : info.message(), Message.Direction.Outgoing));
        this.source.send(info.message(), this.responseReceiver());
    }

    public void sendAttachment(String content) {
        this.add(Message.with(content, Message.Direction.Outgoing, List.of(this.attachment.name())));
        this.add(Message.with("", Message.Direction.Incoming).active(true));
        this.source.send(content, List.of(this.attachment), this.responseReceiver());
    }

    public void previousMessages() {
        List<ChatMessage> messages = this.messages();
        if (messages.size() < 50) {
            ((ChatNotifier)this.notifier).messagesStartReached();
        }
        ((ChatNotifier)this.notifier).addPreviousMessages(messages);
    }

    @Override
    public void didMount() {
        super.didMount();
        this.refresh();
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.source == null) {
            return;
        }
        this.reader = this.source.messages();
        List<ChatMessage> messages = this.messages();
        if (messages.size() < 50) {
            ((ChatNotifier)this.notifier).messagesStartReached();
        }
        ((ChatNotifier)this.notifier).refresh(this.info(messages));
        if (this.emptyMessage != null && messages.isEmpty()) {
            this.add(Message.with(this.translate(this.emptyMessage), Message.Direction.Incoming));
        }
    }

    private ChatInfo info(List<ChatMessage> messages) {
        ChatInfo result = new ChatInfo();
        result.label(this.label());
        result.messages(messages);
        if (this.incomingImage != null) {
            result.incomingImage(this.assetUrl(this.incomingImage));
        }
        if (this.outgoingImage != null) {
            result.outgoingImage(this.assetUrl(this.outgoingImage));
        }
        if (this.loadingImage != null) {
            result.loadingImage(this.assetUrl(this.loadingImage));
        }
        return result;
    }

    protected void _incomingImage(URL image) {
        this.incomingImage = image;
    }

    protected void _outgoingImage(URL image) {
        this.outgoingImage = image;
    }

    protected void _loadingImage(URL image) {
        this.loadingImage = image;
    }

    protected void _emptyMessage(String message) {
        this.emptyMessage = message;
    }

    private List<ChatMessage> messages() {
        return this.messages(this.condition).stream().map(this::schemaOf).collect(Collectors.toList());
    }

    public List<Message> messages(String condition) {
        ArrayList<Message> result = new ArrayList<Message>();
        for (Message next : this.reader) {
            if (this.accepts(next, condition)) {
                result.add(next);
            }
            if (result.size() != 50) continue;
            break;
        }
        return result;
    }

    private boolean accepts(Message next, String condition) {
        if (condition == null) {
            return true;
        }
        return next.content().toLowerCase().contains(condition.toLowerCase());
    }

    private ChatMessage schemaOf(Message message) {
        return new ChatMessage().date(message.ts()).content(message.content()).active(message.active()).direction(ChatMessage.Direction.valueOf(message.direction().name())).attachments(this.attachments(message));
    }

    private List<Attachment> attachments(Message message) {
        return message.attachments().stream().map(a -> this.attachment(message, (String)a)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Attachment attachment(Message message, String name) {
        URL url = this.source.attachmentUrl(message, name);
        if (url == null) {
            return null;
        }
        String extension = name.contains(".") ? name.substring(name.lastIndexOf(".")) : name;
        return new Attachment().filename(name).mimeType(MimeTypes.contentTypeOf((String)extension)).url(this.assetUrl(url));
    }

    private ChatDatasource.ResponseReceiver responseReceiver() {
        return new ChatDatasource.ResponseReceiver(){

            @Override
            public ChatDatasource.ResponseReceiver.MessageBuffer create(String content) {
                ((ChatNotifier)Chat.this.notifier).closeMessage();
                Chat.this.add(Message.with(content, Message.Direction.Incoming).active(true));
                return new ChatDatasource.ResponseReceiver.MessageBuffer(){

                    @Override
                    public ChatDatasource.ResponseReceiver.MessageBuffer add(String content) {
                        ((ChatNotifier)Chat.this.notifier).addMessagePart(content);
                        return this;
                    }

                    @Override
                    public ChatDatasource.ResponseReceiver.MessageBuffer end() {
                        ((ChatNotifier)Chat.this.notifier).closeMessage();
                        return this;
                    }
                };
            }
        };
    }
}

