/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.Json;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.schemas.DynamicTableRowParams;
import io.intino.alexandria.schemas.DynamicTableRowsParams;
import io.intino.alexandria.schemas.DynamicTableVisibleColumn;
import io.intino.alexandria.ui.displays.components.DynamicTable;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.displays.requesters.PageCollectionRequester;
import io.intino.alexandria.ui.spark.UISparkManager;
import java.util.List;

public class DynamicTableRequester
extends PageCollectionRequester {
    public DynamicTableRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
    }

    @Override
    public void execute() throws AlexandriaException {
        DynamicTable display = (DynamicTable)this.display();
        if (display == null) {
            return;
        }
        String operation = this.operation();
        if (operation.equals("openRow")) {
            display.openRow((DynamicTableRowParams)Json.fromString((String)this.manager.fromQuery("v"), DynamicTableRowParams.class));
            return;
        }
        if (operation.equals("selectRows")) {
            display.selectRows(List.of((DynamicTableRowsParams[])Json.fromString((String)this.manager.fromQuery("v"), DynamicTableRowsParams[].class)));
            return;
        }
        if (operation.equals("showItems")) {
            display.showItems((DynamicTableRowParams)Json.fromString((String)this.manager.fromQuery("v"), DynamicTableRowParams.class));
            return;
        }
        if (operation.equals("visibleColumns")) {
            display.visibleColumns(List.of((DynamicTableVisibleColumn[])Json.fromString((String)this.manager.fromQuery("v"), DynamicTableVisibleColumn[].class)));
            return;
        }
        if (operation.equals("showZeros")) {
            display.showZeros((Boolean)Json.fromString((String)this.manager.fromQuery("v"), Boolean.class));
            return;
        }
        if (operation.equals("showPercentages")) {
            display.showPercentages((Boolean)Json.fromString((String)this.manager.fromQuery("v"), Boolean.class));
            return;
        }
        super.execute();
    }
}

