package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.Timeline;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.spark.UISparkManager;

public class TimelineRequester extends io.intino.alexandria.ui.displays.requesters.ComponentRequester {

	public TimelineRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		Timeline display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("openHistory")) {
			display.openHistory(manager.fromQuery("v"));
			return;
		}
		else if (operation.equals("historyWithRelativeValues")) {
			display.historyWithRelativeValues(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), Boolean.class));
			return;
		}
		else if (operation.equals("fetch")) {
			display.fetch(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.TimelineHistoryFetch.class));
			return;
		}
		else if (operation.equals("magnitudesVisibility")) {
			display.magnitudesVisibility(java.util.List.of(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.TimelineMagnitudeVisibility[].class)));
			return;
		}
		else if (operation.equals("magnitudesSorting")) {
			display.magnitudesSorting(java.util.List.of(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.TimelineMagnitudeSorting[].class)));
			return;
		}

		super.execute();
	}
}