/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.documentation.model.data;

import io.intino.alexandria.schemas.Property;
import io.intino.alexandria.ui.documentation.Model;
import io.intino.alexandria.ui.documentation.model.BaseWidget;
import java.util.Arrays;
import java.util.Collections;

public class DateWidget
extends BaseWidget {
    public DateWidget() {
        super("No worries about rendering dates in client side. This widget enables date rendering in a easy way.");
        this.facets(Arrays.asList("Multiple", "Code", "Editable"));
    }

    @Override
    protected void addProperties() {
        super.addProperties();
        this.add(Model.property("value", Property.Type.Text, "The initial text to display in the box, if any", new String[0]));
        this.add(Model.property("pattern", Property.Type.Text, "Pattern is defined using momentjs format", "DD/MM/YYYY"));
        this.add(Model.property("mode", Property.Type.Word, "Defines date value with a relative time. Displays the date as the time from or to now", "FromNow", "ToNow"));
        this.add(Model.property("timePicker", Property.Type.Bool, "Defines if the edition component allows time selection", new String[0]).facets(Collections.singletonList("Editable")));
        this.add(Model.property("min", Property.Type.Instant, "Defines the min instant allowed", new String[0]).facets(Collections.singletonList("Editable")));
        this.add(Model.property("max", Property.Type.Instant, "Defines the max instant allowed", new String[0]).facets(Collections.singletonList("Editable")));
        this.add(Model.property("mask", Property.Type.Text, "Defines the mask to show for user when editing. Example: '__/__/____'", new String[0]).facets(Collections.singletonList("Editable")));
    }

    @Override
    protected void addMethods() {
        super.addMethods();
        this.addMethod(Model.method("get", Collections.emptyList(), "Returns the value that the widget stores", "java.time.Instant"));
        this.addMethod(Model.method("update", Collections.singletonList(Model.methodParameter("instant", "java.time.Instant")), "Updates date widget with new instant value", "void"));
    }

    @Override
    protected void addEvents() {
        super.addEvents();
        this.addEvent(Model.method("onChange", Collections.singletonList(Model.methodParameter("listener", "io.intino.alexandria.ui.displays.events.ChangeListener")), "This event is fired when widget value changes", "void").facets(Collections.singletonList("Editable")));
    }
}

