/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.CollectionItemsRenderedInfo;
import io.intino.alexandria.schemas.CollectionMoreItems;
import io.intino.alexandria.schemas.PageCollectionSetup;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.components.AbstractPageCollection;
import io.intino.alexandria.ui.displays.components.collection.behaviors.CollectionBehavior;
import io.intino.alexandria.ui.displays.components.collection.behaviors.PageCollectionBehavior;
import io.intino.alexandria.ui.displays.events.AddCollectionItemEvent;
import io.intino.alexandria.ui.displays.notifiers.PageCollectionNotifier;
import io.intino.alexandria.ui.model.datasource.PageDatasource;
import java.util.List;

public abstract class PageCollection<DN extends PageCollectionNotifier, B extends Box>
extends AbstractPageCollection<DN, B> {
    private int pageSize = 20;

    public PageCollection(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        ((PageCollectionNotifier)this.notifier).setupPageCollection((PageCollectionSetup)new PageCollectionSetup().pageSize(this.pageSize).itemCount(this.behavior() != null ? ((CollectionBehavior)this.behavior()).itemCount() : 0L));
        this.notifyReady();
    }

    public int pageSize() {
        return this.pageSize;
    }

    public void notifyItemsRendered(CollectionItemsRenderedInfo info) {
        this.promisedChildren(info.items()).forEach(this::register);
        List<Display> children = this.children(info.visible());
        int i = 0;
        while (i < children.size()) {
            int index = i++;
            this.addItemListener().ifPresent(l -> l.accept(this.itemEvent((Display)children.get(index), index)));
        }
        this.notifyRefresh();
    }

    public void loadNextPage() {
        PageCollectionBehavior behavior = (PageCollectionBehavior)this.behavior();
        behavior.nextPage();
    }

    public void loadMoreItems(CollectionMoreItems info) {
        PageCollectionBehavior behavior = (PageCollectionBehavior)this.behavior();
        behavior.moreItems(info);
    }

    public void changePage(Integer page) {
        PageCollectionBehavior behavior = (PageCollectionBehavior)this.behavior();
        behavior.page(page);
        ((PageCollectionNotifier)this.notifier).refresh();
    }

    public void changePageSize(Integer size) {
        PageCollectionBehavior behavior = (PageCollectionBehavior)this.behavior();
        behavior.pageSize(size);
        ((PageCollectionNotifier)this.notifier).refresh();
    }

    protected PageCollection<DN, B> _pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    protected abstract AddCollectionItemEvent itemEvent(Display var1, int var2);

    @Override
    void setup() {
        PageDatasource source = (PageDatasource)this.source();
        if (source == null) {
            return;
        }
        PageCollectionBehavior behavior = (PageCollectionBehavior)this.behavior();
        behavior.setup(source, this.pageSize);
        ((PageCollectionNotifier)this.notifier).setupPageCollection((PageCollectionSetup)new PageCollectionSetup().pageSize(this.pageSize).itemCount(behavior.itemCount()));
        this.notifyReady();
    }
}

